/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

public class FPGA2ModelUtils {
    private final FPGA2Model model;
    private final Map<String, Object> parameterOverrides;

    public FPGA2ModelUtils(FPGA2Model model, Map<String, Object> parameterOverrides) {
        this.model = model;
        this.parameterOverrides = parameterOverrides;
    }

    private Function getFunctionForName(String name) {
        for (Function f : this.model.functionsMap.keySet()) {
            if (!f.getId().equals(name)) continue;
            return f;
        }
        throw new IllegalArgumentException("Function not found: " + name);
    }

    private FPGA2Model.FPGARoutine getRoutineForName(String name) {
        for (FPGA2Model.FPGARoutine f : this.model.routines) {
            if (!f.orgRoutine.getId().equals(name)) continue;
            return f;
        }
        throw new IllegalArgumentException("Routine not found: " + name);
    }

    public long getNanosForFunction(String name) {
        Function f = this.getFunctionForName(name);
        LinkedList<Timeslice> timeslices = f.getTimeslices();
        Timeslice last = timeslices.getLast();
        if (last == null) {
            return -1L;
        }
        return last.getDurationNanos() + last.getStartNanos() + 20 + ("Default".equals(name) ? 10 : 0);
    }

    public PixelCount getPixelsForFunction(String name) {
        Function f = this.getFunctionForName(name);
        LinkedList<Timeslice> timeslices = f.getTimeslices();
        long pixelCount = 0L;
        boolean hasSOI = false;
        boolean hasEOI = false;
        boolean wasSet = false;
        for (Timeslice slice : timeslices) {
            boolean trgSet = false;
            for (Channel c : slice.getUpChannels()) {
                switch (c.getId()) {
                    case "TRG": {
                        trgSet = true;
                        break;
                    }
                    case "SOI": {
                        hasSOI = true;
                        break;
                    }
                    case "EOI": {
                        hasEOI = true;
                    }
                }
            }
            if (trgSet == wasSet) continue;
            if (trgSet) {
                ++pixelCount;
            }
            wasSet = trgSet;
        }
        return new PixelCount(pixelCount, hasSOI, hasEOI);
    }

    private void visitCallList(List<Call> calls, BiConsumer<String, LongWithInfinity> visitFunction, BiConsumer<String, LongWithInfinity> visitRoutine) {
        for (Call call : calls) {
            LongWithInfinity repeat = new LongWithInfinity(call.getRepeatValue(), call.isInfinity());
            Function function = call.getFunction();
            FunctionPointer functionPointer = call.getFunctionPointer();
            Subroutine subroutine = call.getSubroutine();
            SubroutinePointer subroutinePointer = call.getSubroutinePointer();
            if (function != null || functionPointer != null) {
                String fcnName = call.getFcnName();
                if (functionPointer != null) {
                    fcnName = this.parameterOverrides.containsKey(functionPointer.getId()) ? this.parameterOverrides.get(functionPointer.getId()).toString() : functionPointer.getFcnName();
                }
                RepeatFunctionPointer repeatFcnPtr = call.getRepeatFcnPtr();
                if (repeat.isZero()) {
                    repeat = this.parameterOverrides.containsKey(repeatFcnPtr.getId()) ? new LongWithInfinity(((Integer)this.parameterOverrides.get(repeatFcnPtr.getId())).intValue()) : new LongWithInfinity(repeatFcnPtr.getN());
                }
                visitFunction.accept(fcnName, repeat);
                continue;
            }
            if (subroutine == null && subroutinePointer == null) continue;
            String subName = call.getSubName();
            if (subroutinePointer != null) {
                subName = this.parameterOverrides.containsKey(subroutinePointer.getId()) ? this.parameterOverrides.get(subroutinePointer.getId()).toString() : subroutinePointer.getSubName();
            }
            RepeatSubroutinePointer repeatSubPtr = call.getRepeatSubPtr();
            if (repeat.isZero()) {
                repeat = this.parameterOverrides.containsKey(repeatSubPtr.getId()) ? new LongWithInfinity(((Integer)this.parameterOverrides.get(repeatSubPtr.getId())).intValue()) : new LongWithInfinity(repeatSubPtr.getN());
            }
            visitRoutine.accept(subName, repeat);
        }
    }

    public LongWithInfinity getNanosForRoutine(String name) {
        FPGA2Model.FPGARoutine f = this.getRoutineForName(name);
        LongWithInfinity[] totalNanos = new LongWithInfinity[]{LongWithInfinity.ZERO};
        Subroutine orgRoutine = (Subroutine)f.orgRoutine;
        List<Call> calls = orgRoutine.getCalls();
        this.visitCallList(calls, (fcnName, repeat) -> {
            totalNanos[0] = totalNanos[0].add(repeat.times(this.getNanosForFunction((String)fcnName)));
        }, (subName, repeat) -> {
            totalNanos[0] = totalNanos[0].add(repeat.times(this.getNanosForRoutine((String)subName)));
        });
        return totalNanos[0];
    }

    public LongWithInfinity getPixelsForRoutine(String name) {
        return this.getPixelsForRoutine(name, false);
    }

    private LongWithInfinity getPixelsForRoutine(String name, boolean soiActive) {
        FPGA2Model.FPGARoutine f = this.getRoutineForName(name);
        LongWithInfinity[] totalPixels = new LongWithInfinity[]{LongWithInfinity.ZERO};
        boolean[] currentSoiActive = new boolean[]{soiActive};
        Subroutine orgRoutine = (Subroutine)f.orgRoutine;
        List<Call> calls = orgRoutine.getCalls();
        this.visitCallList(calls, (fcnName, repeat) -> {
            PixelCount pixelsForFunction = this.getPixelsForFunction((String)fcnName);
            currentSoiActive[0] = currentSoiActive[0] | pixelsForFunction.hasSOI;
            currentSoiActive[0] = currentSoiActive[0] & !pixelsForFunction.hasEOI;
            if (currentSoiActive[0]) {
                totalPixels[0] = totalPixels[0].add(repeat.times(pixelsForFunction.pixelCount));
            }
        }, (subName, repeat) -> {
            totalPixels[0] = totalPixels[0].add(repeat.times(this.getPixelsForRoutine((String)subName, currentSoiActive[0])));
        });
        return totalPixels[0];
    }

    public static class PixelCount {
        private final long pixelCount;
        private final boolean hasSOI;
        private final boolean hasEOI;

        private PixelCount(long pixelCount, boolean hasSOI, boolean hasEOI) {
            this.pixelCount = pixelCount;
            this.hasSOI = hasSOI;
            this.hasEOI = hasEOI;
        }

        public String toString() {
            return (this.hasSOI ? "SOI " : "") + (this.hasEOI ? "EOI " : "") + (this.pixelCount > 0L ? String.format("%,d", this.pixelCount) : "");
        }
    }

    public static class LongWithInfinity {
        private static final LongWithInfinity ZERO = new LongWithInfinity(0L);
        private final long value;
        private final boolean isInfinite;

        LongWithInfinity(long value, boolean isInfinite) {
            this.value = value;
            this.isInfinite = isInfinite;
        }

        private LongWithInfinity(long value) {
            this(value, false);
        }

        public String toString() {
            return this.isInfinite ? "Infinity" : String.format("%,d", this.value);
        }

        public boolean isZero() {
            return !this.isInfinite && this.value == 0L;
        }

        LongWithInfinity add(LongWithInfinity lwv) {
            return new LongWithInfinity(this.value + lwv.value, this.isInfinite || lwv.isInfinite);
        }

        LongWithInfinity times(LongWithInfinity lwv) {
            return new LongWithInfinity(this.value * lwv.value, this.isInfinite || lwv.isInfinite);
        }

        LongWithInfinity times(long multiplier) {
            return new LongWithInfinity(this.value * multiplier, this.isInfinite);
        }

        long getValue() {
            return this.value;
        }
    }
}

