/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.tree;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.gconsole.util.tree.SNode;
import org.lsst.ccs.gconsole.util.tree.Sort;

public class SModel<T>
extends DefaultTreeModel
implements Savable {
    protected String rootName = "";
    protected Map<String, T> pathToPayloadMap;
    protected Descriptor descriptor = new Descriptor();

    public SModel() {
        super(null);
    }

    public SModel(Map<String, ? extends T> data) {
        super(null);
        this.update(data);
    }

    @Override
    public SNode<T> getChild(Object parent, int index) {
        return (SNode)super.getChild(parent, index);
    }

    @Override
    public SNode<T> getRoot() {
        return (SNode)super.getRoot();
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getRootName() {
        return this.rootName;
    }

    public TreePath getPath(String path) {
        String[] pp = path.split("/+");
        return this.getPath(pp);
    }

    public TreePath getPath(String[] path) {
        Object[] treePath = new Object[path.length + 1];
        SNode node = this.getRoot();
        treePath[0] = node;
        for (int i = 0; i < path.length; ++i) {
            if ((node = node.getChild(path[i])) == null) {
                return null;
            }
            treePath[i + 1] = node;
        }
        return new TreePath(treePath);
    }

    public LinkedHashMap<String, T> getData() {
        return new LinkedHashMap<String, T>(this.pathToPayloadMap);
    }

    public void sort(Sort sort) {
        if (sort == null) {
            sort = Sort.NONE;
        }
        if (this.descriptor.getSort() != sort) {
            this.descriptor.setSort(sort);
            if (this.pathToPayloadMap != null && !this.pathToPayloadMap.isEmpty()) {
                this.update(this.pathToPayloadMap);
            }
        }
    }

    public void update(Map<String, ? extends T> data) {
        Map<String, T> sortedData;
        this.pathToPayloadMap = new LinkedHashMap<String, T>(data);
        if (this.descriptor.getSort() == Sort.NONE) {
            sortedData = this.pathToPayloadMap;
        } else {
            sortedData = new TreeMap<String, T>(this.descriptor.getSort());
            sortedData.putAll(this.pathToPayloadMap);
        }
        SNode root = new SNode(this.rootName);
        for (Map.Entry<String, T> e : sortedData.entrySet()) {
            String[] pp = e.getKey().split("/+");
            SNode parent = root;
            for (String p : pp) {
                int n = parent.getChildCount();
                TreeNode node = null;
                for (int i = 0; i < n; ++i) {
                    TreeNode child = parent.getChildAt(i);
                    if (!p.equals(((SNode)child).getName())) continue;
                    node = child;
                    break;
                }
                if (node == null) {
                    node = new SNode(p);
                    parent.add((MutableTreeNode)node);
                }
                parent = node;
            }
            parent.setUserObject(e.getValue());
        }
        this.setRoot(root);
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor == null) {
            descriptor = new Descriptor();
        }
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
            if (this.pathToPayloadMap != null && !this.pathToPayloadMap.isEmpty()) {
                this.update(this.pathToPayloadMap);
            }
        }
    }

    @Override
    public Descriptor save() {
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private Sort sort = Sort.ALPHABETIC_LEAVES_LAST;

        public Sort getSort() {
            return this.sort;
        }

        public void setSort(Sort sort) {
            this.sort = sort;
        }

        public Descriptor clone() {
            try {
                return (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

