/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class AbstractAgentLockServiceDelegate
implements AgentLockServiceDelegate,
AgentPresenceListener,
AgentLoginService.AgentLoginUpdateListener {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.lockservice");
    protected AgentLockService svc;
    protected final List<AgentLockService.AgentLockUpdateListener> agentLockUpdateListeners = new CopyOnWriteArrayList<AgentLockService.AgentLockUpdateListener>();
    protected final Map<String, Integer> agentLevels = new ConcurrentHashMap<String, Integer>();
    protected final Map<String, AgentLock> heldLocks = new ConcurrentHashMap<String, AgentLock>();
    protected final Map<String, AgentLock> allLocks = new ConcurrentHashMap<String, AgentLock>();
    protected AgentLock myCurrentLock = null;
    protected final Object lockLevelUpdate = new Object();
    protected final Semaphore lockListenersSemaphore = new Semaphore(1, true);

    protected Agent getAgent() {
        return this.svc.getAgent();
    }

    protected AgentStateService getAgentStateService() {
        return this.svc.getAgentStateService();
    }

    public AbstractAgentLockServiceDelegate(AgentLockService svc) {
        this.svc = svc;
    }

    @Override
    public void preInit() {
        log.debug((Object)("AbstractAgentLockServiceDelegate preInit for " + this));
        this.getAgent().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.svc.getAgentLoginService().addAgentLoginUpdateListener(this);
    }

    @Override
    public void preStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLevelForAgent(String agentName) {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            if (this.getHeldLocks().get(agentName) == null) {
                return 0;
            }
            return this.agentLevels.getOrDefault(agentName, 0);
        }
    }

    @Override
    public AgentLock getLockForAgent(String agentName) {
        AgentLock lock = this.getHeldLocks().get(agentName);
        if (lock != null && !lock.getOwner().equals(this.svc.getUserId())) {
            return null;
        }
        return lock;
    }

    @Override
    public AgentLock getExistingLockForAgent(String agentName) {
        AgentLock lock = this.getAllLocks().get(agentName);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AgentLock> getHeldLocks() {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            HashMap<String, AgentLock> res = new HashMap<String, AgentLock>();
            this.heldLocks.entrySet().stream().filter(e -> ((AgentLock)e.getValue()).getOwner().equals(this.svc.getUserId())).forEach(e -> {
                AgentLock cfr_ignored_0 = (AgentLock)res.put((String)e.getKey(), (AgentLock)e.getValue());
            });
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AgentLock> getAllLocks() {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            return Collections.unmodifiableMap(this.allLocks);
        }
    }

    public AgentLock getCurrentLock() {
        return this.myCurrentLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAgentLockUpdateListener(AgentLockService.AgentLockUpdateListener aluListener) {
        HashMap<String, AgentLock> heldLocksCopy = null;
        Iterator iterator = this.lockLevelUpdate;
        synchronized (iterator) {
            heldLocksCopy = new HashMap<String, AgentLock>(this.heldLocks);
        }
        try {
            this.lockListenersSemaphore.acquireUninterruptibly();
            for (Map.Entry entry : heldLocksCopy.entrySet()) {
                aluListener.onAgentHeldLockUpdate((String)entry.getKey(), (AgentLock)entry.getValue());
            }
            this.agentLockUpdateListeners.add(aluListener);
        }
        catch (Exception e) {
            log.error((Object)"exception while adding listener", (Throwable)e);
        }
        finally {
            this.lockListenersSemaphore.release();
        }
    }

    @Override
    public void removeAgentLockUpdateListener(AgentLockService.AgentLockUpdateListener aluListener) {
        this.agentLockUpdateListeners.remove(aluListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHeldLock(AgentLock lock) throws UnauthorizedLockException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            String agentName = lock.getAgentName();
            this.heldLocks.put(agentName, lock);
            this.agentLevels.remove(agentName);
        }
        this.notifyHeldLockListeners(lock.getAgentName(), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHeldLock(String agentName, AgentLock info) throws UnauthorizedLockException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            this.heldLocks.remove(agentName);
        }
        this.notifyHeldLockListeners(agentName, null);
    }

    protected void setCurrentLock(AgentLock lock) {
        this.myCurrentLock = lock;
        this.notifyLockListeners(lock.getAgentName(), lock.getOwner(), lock);
    }

    protected void removeCurrentLock() {
        AgentLock oldLock = this.myCurrentLock;
        this.myCurrentLock = null;
        if (oldLock != null) {
            this.notifyLockListeners(oldLock.getAgentName(), oldLock.getOwner(), null);
        }
    }

    protected void notifyLockListeners(String agentName, String owner, AgentLock lock) {
        this.lockListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLockUpdateListeners.forEach(l -> l.onAgentLockUpdate(agentName, owner, lock));
            }
            finally {
                this.lockListenersSemaphore.release();
            }
        });
        t.start();
    }

    @Override
    public void onAgentLoginUpdate(String oldUserId, String newUserId) {
        this.notifyLockVisibility(oldUserId, newUserId);
    }

    protected void notifyLockVisibility(String oldUserid, String newUserid) {
        this.heldLocks.values().stream().filter(l -> l.getOwner().equals(oldUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginInvisble((AgentLockInfo)((AgentLockInfo)l)) : null)));
        this.heldLocks.values().stream().filter(l -> l.getOwner().equals(newUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginVisble((AgentLockInfo)((AgentLockInfo)l)) : l)));
        Set heldLockAgents = this.heldLocks.values().stream().map(AgentLock::getAgentName).collect(Collectors.toSet());
        this.allLocks.values().stream().filter(l -> !heldLockAgents.contains(l.getAgentName())).filter(l -> l.getOwner().equals(oldUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginInvisble((AgentLockInfo)((AgentLockInfo)l)) : null)));
        this.allLocks.values().stream().filter(l -> !heldLockAgents.contains(l.getAgentName())).filter(l -> l.getOwner().equals(newUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginVisble((AgentLockInfo)((AgentLockInfo)l)) : l)));
    }

    protected void notifyHeldLockListeners(String agentName, AgentLock lock) {
        this.lockListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLockUpdateListeners.forEach(l -> l.onAgentHeldLockUpdate(agentName, lock));
            }
            finally {
                this.lockListenersSemaphore.release();
            }
        });
        t.start();
    }

    protected void notifyGlobalLockListeners(String agentName, AgentLock lock) {
        this.lockListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLockUpdateListeners.forEach(l -> l.onGlobalLockUpdate(agentName, lock.getOwner(), lock));
            }
            finally {
                this.lockListenersSemaphore.release();
            }
        });
        t.start();
    }

    protected void notifyLevelListeners(String agentName, int level) {
        this.lockListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLockUpdateListeners.forEach(l -> l.onAgentLevelChange(agentName, level));
            }
            finally {
                this.lockListenersSemaphore.release();
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLevelInternal(String agentName, int level) throws UnauthorizedLevelException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            log.log(Level.FINE, "{0} set level for agent {1} to {2}", new Object[]{this.getAgent().getName(), agentName, level});
            this.agentLevels.put(agentName, level);
        }
        this.notifyLevelListeners(agentName, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLockableAgents() {
        ArrayList<String> result = new ArrayList<String>();
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            for (AgentInfo a : this.getAgent().getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                AgentInfo.AgentType tp = a.getType();
                if (tp != AgentInfo.AgentType.WORKER && tp != AgentInfo.AgentType.MCM && tp != AgentInfo.AgentType.SERVICE || this.allLocks.get(a.getName()) != null) continue;
                result.add(a.getName());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLocallyLockedAgents() {
        ArrayList<String> res = new ArrayList<String>();
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            for (Map.Entry<String, AgentLock> e : this.getHeldLocks().entrySet()) {
                if (e.getValue() == null) continue;
                res.add(e.getKey());
            }
        }
        return res;
    }

    @Override
    public List<String> getLockedAgents() {
        ArrayList<String> res = new ArrayList<String>();
        for (AgentLock lock : this.allLocks.values()) {
            if (!lock.getOwner().equals(this.svc.getUserId())) continue;
            res.add(lock.getAgentName());
        }
        return res;
    }

    @Override
    public List<String> getDetachableAgents() {
        return this.getLocallyLockedAgents();
    }

    @Override
    public List<String> getAttachableAgents() {
        ArrayList<String> result = new ArrayList<String>();
        for (AgentLock lock : this.allLocks.values()) {
            if (!lock.getOwner().equals(this.svc.getUserId()) || this.heldLocks.containsKey(lock.getAgentName())) continue;
            result.add(lock.getAgentName());
        }
        return result;
    }

    @Override
    public List<String> getAllWorkerAgents() {
        return this.getAgent().getMessagingAccess().getAgentPresenceManager().listConnectedAgents().stream().filter(i -> i.getType() == AgentInfo.AgentType.WORKER || i.getType() == AgentInfo.AgentType.MCM).map(i -> i.getName()).collect(Collectors.toList());
    }

    @Override
    public Map<String, AgentLock> getLocks() {
        return Collections.unmodifiableMap(this.allLocks);
    }

    @Override
    public boolean validateLock(AgentLock lock) {
        log.info((Object)("validate lock " + lock + " with " + this.myCurrentLock));
        if (lock == null) {
            return false;
        }
        AgentLock knownLock = this.myCurrentLock;
        if (knownLock == null) {
            return false;
        }
        if (!knownLock.getToken().equals(lock.getToken())) {
            return false;
        }
        if (!knownLock.getOwner().equals(lock.getOwner())) {
            return false;
        }
        return knownLock.getAgentName().equals(lock.getAgentName());
    }
}

