/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.CompoundView;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.command.CommandService;

public class ConfigView
extends AbstractMonitorView {
    private final AbstractMonitorView.Descriptor descriptor = new AbstractMonitorView.Descriptor();
    private static final String STATE_PATH = "/state/ConfigurationState";
    private static final String TIME_PATH = "/runtimeInfo/current time";
    private List<String> agentList;
    private final AgentDataALL ALL;
    private final TreeMap<String, AgentData> agentsData = new TreeMap();
    private AgentData[] model;
    private final GUI panel;

    public ConfigView() {
        this.ALL = new AgentDataALL();
        this.model = new AgentData[]{this.ALL};
        this.filter = new AbstractChannelsFilter(){

            @Override
            public List<String> getAgents() {
                return ConfigView.this.agentList;
            }

            @Override
            public List<String> getOriginChannels() {
                return Arrays.asList(ConfigView.STATE_PATH, ConfigView.TIME_PATH);
            }
        };
        this.panel = new GUI();
    }

    public static PersistableMonitorView decorateView(PersistableMonitorView view) {
        CompoundView out = new CompoundView(new JPanel(new BorderLayout()));
        out.addView(view, CompoundView.Mode.INDEPENDENT);
        out.getPanel().add((Component)view.getPanel(), "Center");
        ConfigView controlView = new ConfigView();
        AgentChannelsFilter filter = view.getFilter();
        if (filter instanceof PersistableAgentChannelsFilter) {
            controlView.setFilter(filter);
        }
        out.addView(controlView, CompoundView.Mode.INDEPENDENT);
        out.getPanel().add((Component)controlView.getPanel(), "South");
        return out;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        List<String> aa;
        this.agentList = filter == null ? null : ((aa = filter.getAgents()) == null ? null : new ArrayList<String>(aa));
    }

    @Override
    public AbstractMonitorView.Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void addChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        channels.forEach(e -> {
            AgentChannel channel = (AgentChannel)e.getValue();
            String agent = channel.getAgentName();
            AgentData agentData = this.agentsData.get(agent);
            if (agentData == null) {
                agentData = new AgentData();
                this.agentsData.put(agent, agentData);
            }
            if (((String)e.getKey()).endsWith(STATE_PATH)) {
                agentData.configState = (AgentChannel)e.getValue();
            } else if (((String)e.getKey()).endsWith(TIME_PATH)) {
                agentData.time = (AgentChannel)e.getValue();
            }
        });
        this.updateModel();
        this.panel.reset();
    }

    @Override
    public void removeChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        for (AgentInfo a : agents) {
            this.agentsData.remove(a.getName());
        }
        this.updateModel();
        this.panel.reset();
    }

    @Override
    public void updateChannels(List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels) {
        boolean stateChange;
        String selection = this.panel.getSelectedItem().getName();
        if (channels == null) {
            stateChange = true;
            this.panel.updateTime();
        } else {
            stateChange = false;
            for (Map.Entry<String, Map.Entry<AgentChannel, List<String>>> e : channels) {
                AgentChannel channel = e.getValue().getKey();
                String agentName = channel.getAgentName();
                if (channel.getPath().endsWith(STATE_PATH)) {
                    stateChange = true;
                    continue;
                }
                if (!agentName.equals(selection)) continue;
                this.panel.updateTime();
            }
        }
        if (stateChange) {
            this.combineStates();
            this.panel.updateState();
        }
        this.ALL.time = Instant.now();
        if (this.ALL.getName().equals(selection)) {
            this.panel.updateTime();
        }
    }

    private void combineStates() {
        this.ALL.state = ConfigurationState.CONFIGURED.toString();
        String dirty = ConfigurationState.DIRTY.toString();
        for (AgentData ad : this.model) {
            if (!dirty.equals(ad.getState())) continue;
            this.ALL.state = dirty;
            return;
        }
    }

    private void updateModel() {
        this.model = new AgentData[this.agentsData.size() + 1];
        this.model[0] = this.ALL;
        int i = 1;
        for (AgentData item : this.agentsData.values()) {
            this.model[i++] = item;
        }
        this.ALL.time = Instant.now();
        this.combineStates();
    }

    private String formatTime(Instant time) {
        try {
            return String.format("%1$tF %1$tT.", ZonedDateTime.ofInstant(time, ZoneId.systemDefault()));
        }
        catch (NullPointerException | DateTimeException | IllegalFormatException x) {
            return "unknown.";
        }
    }

    private class AgentDataALL
    extends AgentData {
        String state;
        Instant time;

        private AgentDataALL() {
            this.state = ConfigurationState.CONFIGURED.toString();
        }

        @Override
        String getName() {
            return "ALL";
        }

        @Override
        Instant getTime() {
            return this.time;
        }

        @Override
        String getState() {
            return this.state;
        }

        void updateTime(AgentData agent) {
            Instant agentTime = agent.getTime();
            if (agentTime != null && (this.time == null || agentTime.isAfter(this.time))) {
                this.time = agentTime;
            }
        }
    }

    private class AgentData {
        AgentChannel configState;
        AgentChannel time;

        private AgentData() {
        }

        String getState() {
            if (this.configState == null) {
                return ConfigurationState.CONFIGURED.toString();
            }
            Object v = this.configState.get();
            return v == null ? ConfigurationState.CONFIGURED.toString() : v.toString();
        }

        Instant getTime() {
            return this.time == null ? null : (Instant)this.time.get();
        }

        String getName() {
            return this.time == null ? this.configState.getAgentName() : this.time.getAgentName();
        }

        public String toString() {
            return this.getName();
        }
    }

    private final class GUI
    extends JPanel {
        private final JComboBox<AgentData> agentCombo;
        private final JLabel timeLabel;
        private final JButton saveButton;
        private final JButton resetButton;

        GUI() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalGlue());
            Box box = Box.createHorizontalBox();
            this.add(box);
            box.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.agentCombo = new JComboBox<AgentData>(ConfigView.this.model);
            this.agentCombo.setEditable(false);
            this.agentCombo.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.agentCombo.getPreferredSize().height));
            this.agentCombo.setForeground(Color.red);
            this.agentCombo.addActionListener(e -> {
                AgentData ad = (AgentData)this.agentCombo.getSelectedItem();
                if (ad == null) {
                    return;
                }
                this.onSelection(ad);
            });
            ListCellRenderer<AgentData> renderer = this.agentCombo.getRenderer();
            this.agentCombo.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
                boolean dirty;
                Component c = renderer.getListCellRendererComponent(list, (AgentData)value, index, isSelected, cellHasFocus);
                if (!isSelected && (dirty = ConfigurationState.DIRTY.toString().equals(value.getState()))) {
                    c.setForeground(Color.BLUE);
                }
                return c;
            });
            box.add(this.agentCombo);
            box.add(Box.createRigidArea(Const.HDIM));
            box.add(new JLabel("Last updated: "));
            this.timeLabel = new JLabel("Never");
            box.add(this.timeLabel);
            box.add(Box.createRigidArea(new Dimension(30, 5)));
            box.add(Box.createHorizontalGlue());
            this.saveButton = new JButton("Save");
            this.saveButton.addActionListener(e -> {
                AgentData selectedAgent = (AgentData)this.agentCombo.getSelectedItem();
                if (selectedAgent != null && selectedAgent != ConfigView.this.ALL && ConfigurationState.DIRTY.toString().equals(selectedAgent.getState())) {
                    CommandService.getService().sendEncoded(selectedAgent.getName(), "saveChangesForCategories", "Limits");
                }
            });
            box.add(this.saveButton);
            box.add(Box.createRigidArea(Const.HDIM));
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(e -> {
                AgentData selectedAgent = (AgentData)this.agentCombo.getSelectedItem();
                if (selectedAgent != null && selectedAgent != ConfigView.this.ALL && ConfigurationState.DIRTY.toString().equals(selectedAgent.getState())) {
                    CommandService.getService().sendEncoded(selectedAgent.getName(), "dropChangesForCategories", "Limits");
                }
            });
            box.add(this.resetButton);
            box.setMaximumSize(new Dimension(Integer.MAX_VALUE, box.getPreferredSize().height));
            this.add(box);
        }

        void reset() {
            AgentData selected = this.getSelectedItem();
            this.agentCombo.removeAllItems();
            this.agentCombo.setModel(new DefaultComboBoxModel<AgentData>(ConfigView.this.model));
            this.agentCombo.setSelectedItem(selected);
            if (this.agentCombo.getSelectedIndex() == -1) {
                this.agentCombo.setSelectedItem(ConfigView.this.ALL);
            }
        }

        private void onSelection(AgentData item) {
            this.timeLabel.setText(ConfigView.this.formatTime(item.getTime()));
            Boolean b = ConfigurationState.DIRTY.toString().equals(item.getState());
            this.saveButton.setEnabled(b != false && item != ConfigView.this.ALL);
            this.resetButton.setEnabled(b != false && item != ConfigView.this.ALL);
            boolean dirty = ConfigurationState.DIRTY.toString().equals(item.getState());
            this.agentCombo.setForeground(dirty ? Color.BLUE : Color.BLACK);
        }

        void updateState() {
            this.onSelection(this.getSelectedItem());
            this.agentCombo.repaint();
        }

        void updateTime() {
            AgentData item = this.getSelectedItem();
            if (item != null) {
                this.timeLabel.setText(ConfigView.this.formatTime(item.getTime()));
            }
        }

        AgentData getSelectedItem() {
            return (AgentData)this.agentCombo.getSelectedItem();
        }
    }
}

