/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.rafts.data.RaftState;

public class RaftsMonitorPanel
extends JPanel
implements CommandSender.ReplyHandler {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private static final long serialVersionUID = 1L;

    public RaftsMonitorPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((RaftState)reply);
    }

    public void updatePanel(RaftState state) {
        SwingUtilities.invokeLater(new UpdatePanel(state));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.add((Component)this.statusPanel);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            RaftsMonitorPanel.this.statusPanel.disablePanel();
            RaftsMonitorPanel.this.repaint();
        }
    }

    class UpdatePanel
    implements Runnable {
        private final RaftState state;

        UpdatePanel(RaftState state) {
            this.state = state;
        }

        @Override
        public void run() {
            RaftsMonitorPanel.this.statusPanel.updatePanel(this.state.getTickMillis());
            RaftsMonitorPanel.this.repaint();
        }
    }
}

