/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IAnnotation;
import hep.aida.ICloud1D;
import jas.hist.ExtendedStatistics;
import java.util.ArrayList;

class AIDACloudStatistics1D
implements ExtendedStatistics {
    private ICloud1D histo;
    private final String[] statNames = new String[]{"Entries", "Mean", "Rms"};
    private final String nanExtStat = "NaN";
    private final String sumOfWeightsStat = "SumOfWeights";
    private final String outOfRangeStat = "OutOfRange";
    private final String overflowStat = "Overflow";
    private final String underflowStat = "Underflow";

    public AIDACloudStatistics1D(ICloud1D histo) {
        this.histo = histo;
    }

    public String[] getStatisticNames() {
        ArrayList<String> stat = new ArrayList<String>();
        for (int i = 0; i < this.statNames.length; ++i) {
            stat.add(this.statNames[i]);
        }
        if (this.getExtendedStatistic("OutOfRange") != null && (Integer)this.getExtendedStatistic("OutOfRange") != 0) {
            stat.add("OutOfRange");
        }
        if (this.getExtendedStatistic("NaN") != null && (Integer)this.getExtendedStatistic("NaN") != 0) {
            stat.add("NaN");
        }
        if ((double)((Integer)this.getExtendedStatistic("Entries")).intValue() != (Double)this.getExtendedStatistic("SumOfWeights")) {
            stat.add("SumOfWeights");
        }
        this.addAnnotationStatistics(stat);
        String[] statArray = new String[stat.size()];
        for (int i = 0; i < stat.size(); ++i) {
            statArray[i] = (String)stat.get(i);
        }
        return statArray;
    }

    public double getStatistic(String name) {
        if (name.equals("Mean")) {
            return this.histo.mean();
        }
        if (name.equals("Rms")) {
            return this.histo.rms();
        }
        return 0.0;
    }

    public Object getExtendedStatistic(String name) {
        if (name.equals("Entries")) {
            return new Integer(this.histo.entries());
        }
        if (this.histo.isConverted()) {
            if (name.equals("OutOfRange")) {
                return new Integer(this.histo.histogram().extraEntries());
            }
            if (name.equals("Overflow")) {
                return new Integer(this.histo.histogram().binEntries(-1));
            }
            if (name.equals("Underflow")) {
                return new Integer(this.histo.histogram().binEntries(-2));
            }
        } else {
            if (name.equals("OutOfRange")) {
                return new Integer(0);
            }
            if (name.equals("Overflow")) {
                return new Integer(0);
            }
            if (name.equals("Underflow")) {
                return new Integer(0);
            }
        }
        if (name.equals("NaN")) {
            return new Integer(this.histo.nanEntries());
        }
        if (name.equals("SumOfWeights")) {
            return new Double(this.histo.sumOfWeights());
        }
        IAnnotation an = this.histo.annotation();
        if (an == null) {
            return null;
        }
        String v = null;
        try {
            if (an.hasKey("stat." + name)) {
                v = an.value("stat." + name);
            } else if (an.hasKey("stat:" + name)) {
                v = an.value("stat:" + name);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return v;
    }

    private void addAnnotationStatistics(ArrayList stat) {
        IAnnotation an = this.histo.annotation();
        if (an == null) {
            return;
        }
        boolean isOutOfRangeSet = false;
        int n = an.size();
        for (int i = 0; i < n; ++i) {
            try {
                String key = an.key(i);
                String statVal = an.value(i);
                if (!key.toLowerCase().startsWith("stat.") && !key.toLowerCase().startsWith("stat:")) continue;
                String statKey = key.substring(5);
                if (statVal.equalsIgnoreCase("false")) {
                    stat.remove(statKey);
                    continue;
                }
                if ("Overflow".equals(statKey) && (Integer)this.getExtendedStatistic(statKey) == 0 || "Underflow".equals(statKey) && (Integer)this.getExtendedStatistic(statKey) == 0) continue;
                if ("OutOfRange".equals(statKey)) {
                    isOutOfRangeSet = true;
                    continue;
                }
                stat.add(statKey);
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (!isOutOfRangeSet && (stat.contains("Overflow") || stat.contains("Underflow"))) {
            stat.remove("OutOfRange");
        }
    }
}

