/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseStyle;
import hep.aida.IPlotterStyle;
import hep.aida.ref.xml.AidaStyleXMLWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class AidaStyleXMLReader {
    private Element rootElement;

    public static IPlotterStyle restoreFromFile(String fileName) throws IOException, JDOMException {
        File file = new File(fileName);
        FileReader reader = new FileReader(file);
        AidaStyleXMLReader xmlReader = new AidaStyleXMLReader(reader);
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        xmlReader.setStyle(style);
        return style;
    }

    public static void setStyleFromFile(IPlotterStyle style, String fileName) throws IOException, JDOMException {
        File file = new File(fileName);
        FileReader reader = new FileReader(file);
        AidaStyleXMLReader xmlReader = new AidaStyleXMLReader(reader);
        xmlReader.setStyle(style);
    }

    public static void setStyleFromFile(IPlotterStyle style, URL fileURL) throws IOException, JDOMException {
        InputStream is = fileURL.openStream();
        InputStreamReader reader = new InputStreamReader(is);
        AidaStyleXMLReader xmlReader = new AidaStyleXMLReader(reader);
        xmlReader.setStyle(style);
    }

    public AidaStyleXMLReader(Reader reader) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(reader);
        this.rootElement = doc.getRootElement();
    }

    public IPlotterStyle createStyle() {
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        this.setStyle((IBaseStyle)style, this.rootElement);
        return style;
    }

    public void setStyle(IPlotterStyle style) {
        this.setStyle((IBaseStyle)style, this.rootElement);
    }

    void setStyle(IBaseStyle style, Element el) {
        if (!el.getName().equals("aidaStyle") && !el.getName().equals("aidaPlotterStyle")) {
            System.out.println("***** AidaStyleXMLReader.setParameter: wrong element name: " + el.getName() + " ... do nothing here");
            return;
        }
        List children = el.getChildren();
        for (Element childElement : children) {
            String name = childElement.getName();
            if (name.equals("aidaStyle")) {
                String styleName = childElement.getAttributeValue("type");
                IBaseStyle subStyle = null;
                Method method = null;
                try {
                    method = style.getClass().getMethod(styleName, null);
                    subStyle = (IBaseStyle)method.invoke((Object)style, (Object[])null);
                    this.setStyle(subStyle, childElement);
                }
                catch (Exception e) {
                    System.out.println("\t***** Invalid method: " + (method == null ? "null" : method.getName()) + " for: " + styleName + "... do nothing here");
                }
                continue;
            }
            if (!name.equals("aidaStyleAttribute")) continue;
            this.setParameter(style, childElement);
        }
    }

    void setParameter(IBaseStyle style, Element el) {
        if (!el.getName().equals("aidaStyleAttribute")) {
            System.out.println("AidaStyleXMLReader.setParameter: wrong element name: " + el.getName() + " ... do nothing here");
            return;
        }
        String name = el.getAttributeValue("attributeName");
        String value = el.getAttributeValue("attributeValue");
        if (value != null && value.equalsIgnoreCase("null")) {
            value = null;
        }
        style.setParameter(name, value);
    }

    public static void main(String[] args) throws IOException, JDOMException {
        String tmp = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
        tmp = tmp + "<!DOCTYPE aidaPlotterStyle SYSTEM \"http://java.freehep.org/schemas/jaida/1.0/aidaPlotterStyle.dtd\">\n";
        tmp = tmp + "<aidaPlotterStyle>\n";
        tmp = tmp + "<aidaStyle type=\"dataStyle\">\n";
        tmp = tmp + "<aidaStyle type=\"markerStyle\">\n";
        tmp = tmp + "<aidaStyleAttribute attributeName=\"color\" attributeValue=\"red\"/>\n";
        tmp = tmp + "</aidaStyle>\n";
        tmp = tmp + "</aidaStyle>\n";
        tmp = tmp + "</aidaPlotterStyle>\n";
        StringReader reader = new StringReader(tmp);
        AidaStyleXMLReader xmlReader = new AidaStyleXMLReader(reader);
        IPlotterStyle plotterStyle = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        xmlReader.setStyle(plotterStyle);
        boolean writeAllParameters = false;
        String newXmlFileName = "C:/work/Projects/Tests/PlotterStyle-test2.xml";
        AidaStyleXMLWriter.writeToFile(newXmlFileName, plotterStyle, writeAllParameters);
    }
}

