/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelMulti;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;

public abstract class AbstractMonitorView
implements PersistableMonitorView {
    protected PersistableAgentChannelsFilter filter;
    protected MonitorFormat formatter;
    protected final LinkedHashMap<String, DisplayChannel> data = new LinkedHashMap();
    private volatile boolean discardRemovedChannels = false;
    private ArrayList<String> disconnectedAgents;

    public void setDiscardRemovedChannels(boolean discardRemovedChannels) {
        this.discardRemovedChannels = discardRemovedChannels;
    }

    @Override
    public void connect(AgentStatusEvent event) {
    }

    @Override
    public void configure(AgentStatusEvent event) {
        if (!event.isEmpty()) {
            SwingUtilities.invokeLater(() -> this.onConnect(event));
        }
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        if (!event.isEmpty()) {
            SwingUtilities.invokeLater(() -> this.onChange(event));
        }
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        if (!event.isEmpty()) {
            SwingUtilities.invokeLater(() -> this.onDisconnect(event));
        }
    }

    private void onConnect(AgentStatusEvent event) {
        List<AgentInfo> agents = event.getAgents();
        List<Map.Entry<String, AgentChannel>> channels = event.getAddedChannels().stream().flatMap(channel -> this.filter.getDisplayPaths((AgentChannel)channel).stream().map(displayPath -> new AbstractMap.SimpleEntry<String, AgentChannel>((String)displayPath, (AgentChannel)channel))).collect(Collectors.toList());
        this.addChannels(agents, channels);
    }

    private void onChange(AgentStatusEvent event) {
        List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels = event.getStatusChanges().entrySet().stream().flatMap(e -> this.filter.getDisplayPaths((AgentChannel)e.getKey()).stream().map(displayPath -> new AbstractMap.SimpleEntry<String, Map.Entry>((String)displayPath, (Map.Entry)e))).collect(Collectors.toList());
        this.updateChannels(channels);
    }

    private void onDisconnect(AgentStatusEvent event) {
        List<AgentInfo> agents = event.getAgents();
        List<Map.Entry<String, AgentChannel>> channels = event.getRemovedChannels().stream().flatMap(channel -> this.filter.getDisplayPaths((AgentChannel)channel).stream().map(displayPath -> new AbstractMap.SimpleEntry<String, AgentChannel>((String)displayPath, (AgentChannel)channel))).collect(Collectors.toList());
        this.removeChannels(agents, channels);
    }

    public void addChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        boolean needReset = this.doAdd(channels);
        if (!this.discardRemovedChannels) {
            boolean bl = needReset = this.purgeOfflineChannels(agents) || needReset;
        }
        if (needReset) {
            this.resetChannels();
        } else {
            this.update();
        }
    }

    public void updateChannels(List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels) {
        this.doUpdate(channels);
    }

    public void removeChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        List<String> agentNames = agents.stream().map(a -> a.getName()).collect(Collectors.toList());
        if (this.discardRemovedChannels) {
            if (this.doRemove(agentNames)) {
                this.resetChannels();
            } else {
                this.update();
            }
        } else {
            if (this.disconnectedAgents == null) {
                this.disconnectedAgents = new ArrayList<String>(agentNames);
            } else {
                this.disconnectedAgents.addAll(agentNames);
            }
            this.doUpdate(channels.stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), new AbstractMap.SimpleEntry(e.getValue(), null))).collect(Collectors.toList()));
        }
    }

    private boolean doAdd(List<Map.Entry<String, AgentChannel>> channels) {
        boolean needReset = false;
        for (Map.Entry<String, AgentChannel> e : channels) {
            String dp = e.getKey();
            AgentChannel c = e.getValue();
            DisplayChannel dc = this.data.get(dp);
            if (dc == null) {
                dc = this.createChannel(dp);
                dc.addChannel(c);
                this.data.put(dp, dc);
                needReset = true;
                continue;
            }
            dc.addChannel(c);
            dc.update(null);
        }
        return needReset;
    }

    private boolean purgeOfflineChannels(List<AgentInfo> agents) {
        if (this.disconnectedAgents == null) {
            return false;
        }
        Set eventAgents = agents.stream().map(a -> a.getName()).collect(Collectors.toSet());
        ArrayList<String> agentsToPurge = new ArrayList<String>(eventAgents.size());
        Iterator<String> it = this.disconnectedAgents.iterator();
        while (it.hasNext()) {
            String a2 = it.next();
            if (!eventAgents.contains(a2)) continue;
            agentsToPurge.add(a2);
            it.remove();
        }
        if (this.disconnectedAgents.isEmpty()) {
            this.disconnectedAgents = null;
        }
        if (agentsToPurge.isEmpty()) {
            return false;
        }
        boolean needReset = false;
        Iterator<Map.Entry<String, DisplayChannel>> itt = this.data.entrySet().iterator();
        while (itt.hasNext()) {
            Map.Entry<String, DisplayChannel> e = itt.next();
            if (!e.getValue().purgeOfflineChannels(agentsToPurge)) continue;
            itt.remove();
            needReset = true;
        }
        return needReset;
    }

    private boolean doRemove(List<String> agents) {
        boolean needReset = false;
        Iterator<Map.Entry<String, DisplayChannel>> it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            DisplayChannel dc = it.next().getValue();
            List<AgentChannel> oldChannels = dc.getChannels();
            if (!oldChannels.stream().anyMatch(a -> agents.contains(a.getAgentName()))) continue;
            ArrayList<AgentChannel> newChannels = new ArrayList<AgentChannel>(oldChannels.size());
            for (AgentChannel c : oldChannels) {
                if (agents.contains(c.getAgentName())) continue;
                newChannels.add(c);
            }
            if (newChannels.isEmpty()) {
                it.remove();
                needReset = true;
                continue;
            }
            dc.setChannels(newChannels);
            dc.update(null);
        }
        return needReset;
    }

    private void doUpdate(List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels) {
        for (Map.Entry<String, Map.Entry<AgentChannel, List<String>>> e : channels) {
            String displayPath = e.getKey();
            DisplayChannel dc = this.data.get(displayPath);
            List<String> attributes = e.getValue().getValue();
            if (dc == null) continue;
            dc.update(attributes);
        }
        this.update();
    }

    protected void resetChannels() {
    }

    protected void update() {
    }

    protected DisplayChannel createChannel(String displayPath) {
        return new DisplayChannelMulti(displayPath);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public List<String> getGroups() {
        List<String> out = PersistableMonitorView.super.getGroups();
        if (out == null) {
            LinkedHashSet groups = new LinkedHashSet();
            this.data.keySet().forEach(displayPath -> {
                String group = this.getGroup((String)displayPath);
                if (group != null) {
                    groups.add(group);
                }
            });
            return new ArrayList<String>(groups);
        }
        return out;
    }

    @Override
    public PersistableAgentChannelsFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        if (!(filter instanceof PersistableAgentChannelsFilter)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only accepts AbstractChannelsFilter filters");
        }
        this.filter = (PersistableAgentChannelsFilter)filter;
    }

    @Override
    public MonitorFormat getFormater() {
        return this.formatter;
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        this.formatter = formatter;
    }
}

