/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.regions.EhcacheNaturalIdRegion;
import org.hibernate.cache.ehcache.internal.strategy.AbstractEhcacheAccessStrategy;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class NonStrictReadWriteEhcacheNaturalIdRegionAccessStrategy
extends AbstractEhcacheAccessStrategy<EhcacheNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    public NonStrictReadWriteEhcacheNaturalIdRegionAccessStrategy(EhcacheNaturalIdRegion region, SessionFactoryOptions settings) {
        super(region, settings);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region();
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return ((EhcacheNaturalIdRegion)this.region()).get(key);
    }

    @Override
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && ((EhcacheNaturalIdRegion)this.region()).contains(key)) {
            return false;
        }
        ((EhcacheNaturalIdRegion)this.region()).put(key, value);
        return true;
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        ((EhcacheNaturalIdRegion)this.region()).remove(key);
    }

    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        this.remove(session, key);
        return false;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        this.unlockItem(session, key, lock);
        return false;
    }

    @Override
    public void remove(SessionImplementor session, Object key) throws CacheException {
        ((EhcacheNaturalIdRegion)this.region()).remove(key);
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SessionImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues((Object)cacheKey);
    }
}

