/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.adapter;

import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.ref.tree.Tree;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.images.ImageHandler;

public class DataPointSetAdapter
extends DefaultFTreeNodeAdapter {
    private static final Icon dataPointSetIcon = ImageHandler.getIcon((String)"images/DataPointSetIcon.gif", AIDAPlugin.class);
    private Studio app;
    private AIDAPlugin thePlugin;
    private Commands commands = new Commands();

    public DataPointSetAdapter(AIDAPlugin thePlugin, Studio app) {
        super(100);
        this.thePlugin = thePlugin;
        this.app = app;
    }

    public Icon icon(FTreeNode node, Icon oldIcon, boolean selected, boolean expanded) {
        return dataPointSetIcon;
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        this.commands.setSelectedNodes(nodes);
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Show");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Overlay on Current Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Add to Current Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Show in New Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Show on New Page");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Delete");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        return menu;
    }

    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        this.commands.setSelectedNodes(selectedNodes);
        return this.commands;
    }

    public boolean doubleClick(FTreeNode node) {
        this.commands.setSelectedNodes(new FTreeNode[]{node});
        this.commands.onShow();
        return true;
    }

    public String statusMessage(FTreeNode node, String oldMessage) {
        IDataPointSet dps = (IDataPointSet)node.objectForClass(IDataPointSet.class);
        if (dps instanceof IManagedObject) {
            String tmp = "Name: " + ((IManagedObject)dps).name() + ", type: " + ((IManagedObject)dps).type();
            return tmp;
        }
        return "IDataPointSet " + dps.title();
    }

    public class Commands
    extends CommandProcessor {
        private FTreeNode[] selectedNodes;

        void setSelectedNodes(FTreeNode[] selectedNodes) {
            this.selectedNodes = selectedNodes;
        }

        public void onShow() {
            this.show(false, false, false);
        }

        public void onOverlayonCurrentPlot() {
            this.show(false, true, false);
        }

        public void onShowinNewPlot() {
            this.show(false, false, true);
        }

        public void onShowonNewPage() {
            this.show(true, false, false);
        }

        private void show(boolean newPage, boolean overlay, boolean newPlot) {
            this.show(newPage, overlay, newPlot, true);
        }

        private void show(boolean newPage, boolean overlay, boolean newPlot, boolean firstTry) {
            PlotRegion region = null;
            try {
                PlotPage page;
                IDataPointSet dps = (IDataPointSet)this.selectedNodes[0].objectForClass(IDataPointSet.class);
                PlotFactory pf = (PlotFactory)DataPointSetAdapter.this.app.getLookup().lookup(PlotFactory.class);
                PlotPage plotPage = page = newPage ? null : pf.currentPage();
                if (page == null) {
                    page = pf.createPage(null);
                    page.createRegions(1, 1);
                    page.showPage();
                }
                if ((region = page.currentRegion()) == null) {
                    region = page.createRegion(0.0, 0.0, 1.0, 1.0);
                } else if (newPlot) {
                    region = page.addRegion();
                }
                Plotter plotter = region.currentPlot();
                if (plotter == null) {
                    plotter = pf.createPlotterFor(dps.getClass());
                }
                plotter.plot((Object)dps, overlay ? 1 : 0);
                region.showPlot(plotter);
            }
            catch (IllegalArgumentException x) {
                if (firstTry && !newPage && !newPlot) {
                    region.clear();
                    this.show(newPage, overlay, newPlot, false);
                }
                DataPointSetAdapter.this.app.error("Error showing plot", (Throwable)x);
            }
        }

        public void onDelete() {
            FTreeNode[] selectedNodes = DataPointSetAdapter.this.thePlugin.tree().selectedNodes();
            IManagedObject obj = (IManagedObject)selectedNodes[0].objectForClass(IManagedObject.class);
            Tree masterTree = DataPointSetAdapter.this.thePlugin.aidaMasterTree();
            masterTree.rm(masterTree.findPath(obj));
        }
    }
}

