/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.util.Set;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.remote.CCSBusesConfigurationDAO;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.logging.Logger;

public class DualConfigurationDAO
implements ConfigurationDAO {
    Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    LocalConfigurationDAO local;
    CCSBusesConfigurationDAO remote;

    public DualConfigurationDAO(AgentMessagingLayer aml, String descriptionName) {
        String agentName = aml.getAgentInfo().getName();
        this.local = new LocalConfigurationDAO(agentName, descriptionName);
        this.remote = new CCSBusesConfigurationDAO(aml);
    }

    @Override
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDescription) throws ConfigurationServiceException {
        ConfigurationView localView = this.local.loadConfiguration(agentName, configDescription);
        try {
            ConfigurationView remoteView = this.remote.loadConfiguration(agentName, configDescription);
            ConfigurationView diff1 = localView.diff(remoteView);
            ConfigurationView diff2 = remoteView.diff(localView);
            if (!diff1.isEmpty() || !diff2.isEmpty()) {
                this.log.error((Object)"loadConfiguration local/remote mismatch");
                this.log.error((Object)("local  " + localView.toString()));
                this.log.error((Object)("remote " + remoteView.toString()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during remote loadConfiguration", (Throwable)e);
        }
        return localView;
    }

    @Override
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        ConfigurationDescription localCD = this.local.registerConfiguration(agentName, configInfo);
        try {
            ConfigurationDescription remoteCD = this.remote.registerConfiguration(agentName, configInfo);
            if (!localCD.equals(remoteCD)) {
                this.log.error((Object)"registerConfiguration local/remote mismatch");
                this.log.error((Object)("local  " + localCD.toString()));
                this.log.error((Object)("remote " + remoteCD.toString()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during remote registerConfiguration", (Throwable)e);
        }
        return localCD;
    }

    @Override
    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        ConfigurationDescription localCD = this.local.saveChangesForCategoriesAs(agentName, configDesc, configInfo);
        try {
            ConfigurationDescription remoteCD = this.remote.saveChangesForCategoriesAs(agentName, configDesc, configInfo);
            if (!localCD.equals(remoteCD)) {
                this.log.error((Object)"saveChangesForCategoriesAs local/remote mismatch");
                this.log.error((Object)("local  " + localCD.toString()));
                this.log.error((Object)("remote " + remoteCD.toString()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during remote saveChangesForCategoriesAs", (Throwable)e);
        }
        return localCD;
    }

    @Override
    public ConfigurationView loadGlobalConfiguration(String agentName, String name, int version) {
        ConfigurationView localView = this.local.loadGlobalConfiguration(agentName, name, version);
        try {
            ConfigurationView remoteView = this.remote.loadGlobalConfiguration(agentName, name, version);
            ConfigurationView diff1 = localView.diff(remoteView);
            ConfigurationView diff2 = remoteView.diff(localView);
            if (!diff1.isEmpty() || !diff2.isEmpty()) {
                this.log.error((Object)"loadGlobalConfiguration local/remote mismatch");
                this.log.error((Object)("local  " + localView.toString()));
                this.log.error((Object)("remote " + remoteView.toString()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during remote loadGlobalConfiguration", (Throwable)e);
        }
        return localView;
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        Set<String> localConfs = this.local.findAvailableConfigurationsForCategory(agentName, category);
        try {
            Set<String> remoteConfs = this.remote.findAvailableConfigurationsForCategory(agentName, category);
            if (!localConfs.equals(remoteConfs)) {
                this.log.error((Object)"findAvailableConfigurationsForCategory local/remote mismatch");
                this.log.error((Object)("local  " + localConfs.toString()));
                this.log.error((Object)("remote " + remoteConfs.toString()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during remote findAvailableConfigurationsForCategory", (Throwable)e);
        }
        return localConfs;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

