/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAdapterProvider;

class DefaultFTreeNodeAdapterLookup {
    private ArrayList adapterProviders = new ArrayList();
    private Map cachedNodeAdapters = new HashMap();
    private EventListenerList all = new EventListenerList();
    private ChangeEvent event = new ChangeEvent(this);
    private FTree tree;
    private AdapterComparator comparator;

    DefaultFTreeNodeAdapterLookup(FTree tree) {
        this.tree = tree;
        this.comparator = new AdapterComparator(tree);
    }

    public void registerFTreeNodeAdapterProvider(FTreeNodeAdapterProvider provider) {
        this.adapterProviders.add(provider);
        this.cachedNodeAdapters.clear();
    }

    protected List getFTreeNodeAdaptersForClass(Class c) {
        ArrayList<FTreeNodeAdapter> result = (ArrayList<FTreeNodeAdapter>)this.cachedNodeAdapters.get(c);
        if (result == null) {
            result = new ArrayList<FTreeNodeAdapter>();
            for (int i = 0; i < this.adapterProviders.size(); ++i) {
                FTreeNodeAdapter[] adapters = ((FTreeNodeAdapterProvider)this.adapterProviders.get(i)).treeNodeAdaptersForClass(c);
                if (adapters == null) continue;
                for (int j = 0; j < adapters.length; ++j) {
                    if (result.contains(adapters[j])) continue;
                    result.add(adapters[j]);
                }
            }
            Collections.sort(result, this.comparator);
            this.cachedNodeAdapters.put(c, result);
        }
        return result;
    }

    protected void addListener(ChangeListener l) {
        this.all.add(ChangeListener.class, l);
    }

    protected void removeListener(ChangeListener l) {
        this.all.remove(ChangeListener.class, l);
    }

    private void notifyAllListeners() {
        ChangeListener[] l = (ChangeListener[])this.all.getListeners(ChangeListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].stateChanged(this.event);
        }
    }

    private class AdapterComparator
    implements Comparator {
        private FTree tree;

        AdapterComparator(FTree tree) {
            this.tree = tree;
        }

        public int compare(Object obj1, Object obj2) {
            FTreeNodeAdapter a1 = (FTreeNodeAdapter)obj1;
            FTreeNodeAdapter a2 = (FTreeNodeAdapter)obj2;
            if (a1.priority(this.tree) > a2.priority(this.tree)) {
                return -1;
            }
            if (a1.priority(this.tree) < a2.priority(this.tree)) {
                return 1;
            }
            return 0;
        }
    }
}

