package org.lsst.ccs.subsystem.rafts.ui;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.rafts.data.RaftState;

/**
 *  Implements the rafts monitoring control panel.
 *
 *  @author Owen Saxton
 */
public class RaftsMonitorPanel extends JPanel {

    private final CommandSender sender;
    private SystemStatusPanel statusPanel;

    public RaftsMonitorPanel(CommandSender sender) {
        this.sender = sender;
        initComponents();
        (new DisableSystem()).run();
    }

    private void initComponents()
    {
        // Status line panel
        statusPanel = new SystemStatusPanel(sender);
        
        // Whole panel
        add(statusPanel);
    }

    public void updateControlPanel(RaftState state) {
        SwingUtilities.invokeLater(new UpdateControlPanel(state));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    class UpdateControlPanel implements Runnable {

        private final RaftState state;

        UpdateControlPanel(RaftState state) {
            this.state = state;
        }

        @Override
        public void run() {
            statusPanel.updateStatus(state.getTickMillis());
            repaint();
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            statusPanel.disableSystem();
            repaint();
        } 
    }

    private static final long serialVersionUID = 1L;
}
