package org.lsst.ccs.subsystem.rafts.ui.jas;

import java.time.Duration;
import org.lsst.ccs.gconsole.base.Console;

/**
 * Class for sending a command and receiving the response.
 * 
 * @author saxton
 */
public class CommandSender {
        
    private final Console console = Console.getConsole();
    private int defTimeout = 5000;

    public Object sendCommand(String dest, String target, String cmnd, Object... args) {
        return sendCommand(defTimeout, dest, target, cmnd, args);
    }

    public Object sendCommand(int timeout, String dest, String target, String cmnd, Object... args) {
        try {
            return sendCommandRaw(timeout, dest, target, cmnd, args);
        }
        catch (Exception e) {
            console.getLoggerUI().error("Command error: ", e);
            return null;
        }
    }

    public Object sendCommandRaw(String dest, String target, String cmnd, Object... args) throws Exception {
        return sendCommandRaw(defTimeout, dest, target, cmnd, args);
    }

    public Object sendCommandRaw(int timeout, String dest, String target, String cmnd, Object... args) throws Exception {
        String cmd = dest + (target == null ? "" : "/" + target) + "/" + cmnd;
        return console.sendCommand(Duration.ofMillis(timeout), cmd, args);
    }

    public void setTimeout(int timeout) {
        defTimeout = timeout;
    }

}
