/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.data.RaftState;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlPanel;
import org.lsst.ccs.subsystem.rafts.ui.RaftsMonitorPanel;
import org.lsst.ccs.subsystem.rafts.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.rafts.ui.jas.Control;
import org.lsst.ccs.subsystem.rafts.ui.jas.RaftsOptionalPage;

@Plugin(name="Rafts Console Plugin", description="Rafts Console Plugin")
public class RaftsConsolePlugin
extends ConsolePlugin {
    public void initialize() {
        RaftsOptionalPage optPage = new RaftsOptionalPage(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsControl.class, false, "Control");
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
        optPage = new RaftsOptionalPage(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsMonitor.class, true, "Monitor");
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class RaftsMonitor
    implements Control,
    StatusMessageListener {
        private RaftsMonitorPanel ctrlPanel;

        RaftsMonitor() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("RaftState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateSystemStatus((RaftState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.ctrlPanel = new RaftsMonitorPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void setSubsystems(String name) {
            this.ctrlPanel.setSubsystem(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }

    static class RaftsControl
    implements Control,
    StatusMessageListener {
        private RaftsControlPanel ctrlPanel;

        RaftsControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("RaftState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                } else if (sd.getDataKey().equals("ImageState")) {
                    this.ctrlPanel.reportImage((ImageState)sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.enableSystem();
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.ctrlPanel = new RaftsControlPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void setSubsystems(String name) {
            this.ctrlPanel.setSubsystem(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

