/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;

class ASPICConfigPanel
extends JPanel {
    private static final Insets INSETS_STD = new Insets(4, 4, 4, 4);
    private static final int TF_WIDTH = 50;
    private static final int TF_WIDTH_L = 80;
    final int iAspic;
    final ASPIC aspic;
    private final JLabel lbGain = new JLabel("Gain:");
    private final JLabel lbRC = new JLabel("RC:");
    private final JLabel lbClamp = new JLabel("Clamp:");
    private final BinaryTextField tfGain;
    private final BinaryTextField tfRC;
    private final BinaryTextField tfClamp;
    private final JCheckBox cbAf1 = new JCheckBox("FS Gain 1");
    private final JCheckBox cbTm = new JCheckBox("Trans Mode");
    private static final long serialVersionUID = 1L;

    ASPICConfigPanel(int ia, ASPIC a) {
        this.iAspic = ia;
        this.aspic = a;
        this.tfGain = new BinaryTextField(4);
        Dimension d4 = this.tfGain.getPreferredSize();
        d4.width = 50;
        this.tfGain.setPreferredSize(d4);
        this.tfGain.setMinimumSize(d4);
        this.tfRC = new BinaryTextField(4);
        this.tfRC.setPreferredSize(d4);
        this.tfRC.setMinimumSize(d4);
        this.tfClamp = new BinaryTextField(8);
        Dimension d8 = this.tfClamp.getPreferredSize();
        d8.width = 80;
        this.tfClamp.setPreferredSize(d8);
        this.tfClamp.setMinimumSize(d8);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS_STD;
        String title = "ASPIC " + this.iAspic + (this.iAspic % 2 == 0 ? " (upper)" : " (lower)");
        this.setBorder(BorderFactory.createTitledBorder(title));
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.add((Component)this.lbGain, gbc);
        ++gbc.gridx;
        this.add((Component)this.tfGain, gbc);
        ++gbc.gridx;
        this.add((Component)this.lbRC, gbc);
        ++gbc.gridx;
        this.add((Component)this.tfRC, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.lbClamp, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 3;
        this.add((Component)this.tfClamp, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.cbAf1, gbc);
        this.cbAf1.setFocusable(false);
        gbc.gridx += 2;
        this.add((Component)this.cbTm, gbc);
        this.cbTm.setFocusable(false);
    }

    void save() {
        this.aspic.setGain(this.tfGain.getValue());
        this.aspic.setRc(this.tfRC.getValue());
        this.aspic.setClamp(this.tfClamp.getValue());
        this.aspic.setAf1(this.cbAf1.isSelected());
        this.aspic.setTm(this.cbTm.isSelected());
    }

    void read() {
        this.tfGain.setValue(this.aspic.getGain());
        this.tfRC.setValue(this.aspic.getRc());
        this.tfClamp.setValue(this.aspic.getClamp());
        this.cbAf1.setSelected(this.aspic.isAf1());
        this.cbTm.setSelected(this.aspic.isTm());
    }

    static class BinaryTextField
    extends JTextField {
        int value;
        int width;
        private static final long serialVersionUID = 1L;

        BinaryTextField() {
            this(0);
        }

        BinaryTextField(int width) {
            this.width = width;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    this.valueChanged();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent ev) {
                    this.valueChanged();
                }

                @Override
                public void focusGained(FocusEvent ev) {
                }
            });
        }

        void setValue(int value) {
            this.value = value;
            this.showValue();
        }

        int getValue() {
            return this.value;
        }

        private void valueChanged() {
            String text = this.getText();
            try {
                this.value = Integer.parseInt(text, 2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.showValue();
        }

        private void showValue() {
            String text = Integer.toBinaryString(this.value);
            int leng = text.length();
            if (leng < this.width) {
                StringBuilder txt = new StringBuilder();
                for (int j = 0; j < this.width - leng; ++j) {
                    txt.append('0');
                }
                txt.append(text);
                text = txt.toString();
            }
            this.setText(text);
        }
    }
}

