/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.filter;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;

public class RegExFilter
extends AbstractChannelsFilter {
    private final String name;
    private final Pattern pattern;
    private final boolean wholePath;

    @Create(category="AgentChannelsFilter", name="Regular expression filter", path="Built-In/Regular Expression", description="Channels filter that uses a regular expression to select channels and leaves the path unchanged.")
    public RegExFilter(@Par(def="_null_", desc="Filter name. Optional.") String name, @Par(def="_null_", desc="Regular expression to be applied tochanel path.") String regex, @Par(def="true", desc="Match the whole path.") boolean wholePath) {
        this.name = name;
        this.pattern = Pattern.compile(regex);
        this.wholePath = wholePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        boolean accept = this.wholePath ? this.pattern.matcher(originPath).matches() : this.pattern.matcher(originPath).find();
        return accept ? Collections.singletonList(originPath) : Collections.emptyList();
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }
}

