package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.data.RaftState;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlPanel;
import org.lsst.ccs.subsystem.rafts.ui.RaftsMonitorPanel;

/**
 * @author tonyj
 */
@Plugin(name = "Rafts Console Plugin", description = "Rafts Console Plugin")
public class RaftsConsolePlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage optPage;
        optPage = new RaftsOptionalPage(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsControl.class, false, "Control");
        Console.getConsole().getOptionalPageService().add(optPage);
        optPage = new RaftsOptionalPage(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsMonitor.class, true, "Monitor");
        Console.getConsole().getOptionalPageService().add(optPage);
    }
    
    static class RaftsControl implements Control, StatusMessageListener {

        private RaftsControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(RaftState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
                else if (sd.getDataKey().equals(ImageState.KEY)) {
                    ctrlPanel.reportImage((ImageState)((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.enableSystem();
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            return ctrlPanel = new RaftsControlPanel(sndr);
        }

        @Override
        public void setSubsystems(String name) {
            ctrlPanel.setSubsystem(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
    static class RaftsMonitor implements Control, StatusMessageListener {

        private RaftsMonitorPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(RaftState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateSystemStatus((RaftState)obj);
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            return ctrlPanel = new RaftsMonitorPanel(sndr);
        }

        @Override
        public void setSubsystems(String name) {
            ctrlPanel.setSubsystem(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
