package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlGui;

/**
 *
 * @author tonyj
 */
@Plugin(name = "CCS Rafts Console Plugin",
        description = "CCS Rafts Console Plugin")
public class RaftsConsolePlugin extends ConsolePlugin {

    
    private final OptionalPage raftsControlsOptionalPage = new RaftsConsolePlugin.RaftsControlsOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().getOptionalPageService().add(raftsControlsOptionalPage);
    }

    static class RaftsControlsOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY) ) {
                return "CCS Subsystems/"+agent.getName()+"/Controls";                
            }
            return null;
        }

        @Override        
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            RaftsControlGui gui = new RaftsControlGui(agentName);
            gui.initGui();
            gui.getGuiLayout().setName(agent.getName()+" Controls");
            return gui.getGuiLayout();
        }

    }

}
