/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlGui;

@Plugin(name="CCS Rafts Console Plugin", description="CCS Rafts Console Plugin")
public class RaftsConsolePlugin
extends ConsolePlugin {
    private final OptionalPage raftsControlsOptionalPage = new RaftsControlsOptionalPage();

    public void initialize() {
        Console.getConsole().getOptionalPageService().add(this.raftsControlsOptionalPage);
    }

    static class RaftsControlsOptionalPage
    implements OptionalPage {
        RaftsControlsOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY)) {
                return "CCS Subsystems/" + agent.getName() + "/Controls";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            RaftsControlGui gui = new RaftsControlGui(agentName);
            gui.initGui();
            gui.getGuiLayout().setName(agent.getName() + " Controls");
            return gui.getGuiLayout();
        }
    }
}

