/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class Idref
extends SystemFunction {
    public Expression simplify(StaticContext staticContext) throws XPathException {
        Idref idref = (Idref)super.simplify(staticContext);
        idref.addContextDocumentArgument(1, "idref");
        return idref;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], false);
    }

    public int computeSpecialProperties() {
        int n = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        return n;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        NodeInfo nodeInfo = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
        if ((nodeInfo = nodeInfo.getRoot()).getNodeKind() != 9) {
            this.dynamicError("In the idref() function, the tree being searched must be one whose root is a document node", "FODC0001", xPathContext);
            return null;
        }
        DocumentInfo documentInfo = (DocumentInfo)nodeInfo;
        int n = 562;
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            IdrefMappingFunction idrefMappingFunction = new IdrefMappingFunction();
            idrefMappingFunction.document = documentInfo;
            idrefMappingFunction.keyContext = xPathContext;
            SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
            MappingIterator mappingIterator = new MappingIterator(sequenceIterator, idrefMappingFunction, null);
            return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
        }
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return EmptyIterator.getInstance();
        }
        KeyManager keyManager = controller.getKeyManager();
        return keyManager.selectByKey(n, documentInfo, atomicValue, xPathContext);
    }

    private static class IdrefMappingFunction
    implements MappingFunction {
        public DocumentInfo document;
        public XPathContext keyContext;

        private IdrefMappingFunction() {
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            KeyManager keyManager = this.keyContext.getController().getKeyManager();
            AtomicValue atomicValue = item instanceof AtomicValue ? (AtomicValue)item : new StringValue(item.getStringValue());
            return keyManager.selectByKey(562, this.document, atomicValue, this.keyContext);
        }
    }
}

