/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import org.freehep.xml.util.BadXMLException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXErrorHandler
implements ErrorHandler {
    public static final int LEVEL_SUCCESS = 0;
    public static final int LEVEL_WARNING = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_FATAL = 3;
    private int maxLevel = 0;
    private int minLevel;

    public SAXErrorHandler() {
        this(2);
    }

    public SAXErrorHandler(int minLevelForException) {
        this.minLevel = minLevelForException;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.handle(exception, 1, "Warning");
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.handle(exception, 2, "Error");
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.handle(exception, 3, "Fatal");
    }

    private void handle(SAXParseException exception, int level, String levelName) throws SAXException {
        StringBuffer message = new StringBuffer(levelName);
        String fileName = exception.getPublicId();
        if (fileName == null) {
            fileName = exception.getSystemId();
        }
        if (fileName != null) {
            message.append(" at " + fileName);
        }
        message.append(" line " + exception.getLineNumber());
        if (level > this.maxLevel) {
            this.maxLevel = level;
        }
        if (level >= this.minLevel) {
            throw new BadXMLException(message.toString(), (Throwable)exception);
        }
        message.append(": " + exception);
        System.err.println(message);
    }

    public int getErrorLevel() {
        return this.maxLevel;
    }
}

