package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.rafts.data.RaftFullState;
import org.lsst.ccs.subsystem.rafts.data.RaftState;

/**
 *****************************************************************
 *
 *  Implements the rafts control panel / monitor panel assembly.
 *
 *  @author Owen Saxton
 *
 *****************************************************************
 */
public class RaftsMonitorAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    RaftsMonitorPanel panel;
    
    public RaftsMonitorAssembly(RaftsMonitorGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
        panel = new RaftsMonitorPanel(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystem(String raftName) {
        mon.setSubsystems(raftName);
        panel.setSubsystem(raftName);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem(id);
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof RaftFullState) {
            RaftFullState r = (RaftFullState)d;
            mon.updateTableModel(name, r.getMonitorFullState());
            panel.updateControlPanel(id, r.getRaftState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key,
                                 Object d) {
        if (key.equals(RaftState.KEY)) {
            panel.updateControlPanel(id, (RaftState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
