/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlGui;
import org.lsst.ccs.subsystem.rafts.ui.RaftsMonitorGui;

@Plugin(name="CCS Rafts Console Plugin", description="CCS Rafts Console Plugin")
public class RaftsConsolePlugin
extends ConsolePlugin {
    private final OptionalPage raftsMonitoringOptionalPage = new RaftsMonitoringOptionalPage();
    private final OptionalPage raftsControlsOptionalPage = new RaftsControlsOptionalPage();

    public void initialize() {
        Console.getConsole().addOptionalPage(this.raftsMonitoringOptionalPage);
        Console.getConsole().addOptionalPage(this.raftsControlsOptionalPage);
    }

    static class RaftsControlsOptionalPage
    implements OptionalPage {
        RaftsControlsOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPath() {
            return "CCS Subsystems/Rafts/Controls";
        }

        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY)) {
                return agent.getName() + " controls";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            RaftsControlGui gui = new RaftsControlGui(agentName);
            gui.initGui();
            return gui.getGuiLayout();
        }
    }

    static class RaftsMonitoringOptionalPage
    implements OptionalPage {
        RaftsMonitoringOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPath() {
            return "CCS Subsystems/Rafts/Monitoring";
        }

        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY)) {
                return agent.getName();
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            RaftsMonitorGui gui = new RaftsMonitorGui(agentName);
            gui.initGui();
            return gui.getGuiLayout();
        }
    }
}

