package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;

/**
 *
 * @author homer
 */
@Plugin(name = "Rafts Monitoring new plugin", description = "Displays monitor tables for rafts")
public class RaftsMonitorPlugin extends ConsolePlugin {

    private final OptionalPage raftsMonitoringOptionalPage = new RaftsMonitorPlugin.RaftsMonitoringOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().addOptionalPage(raftsMonitoringOptionalPage);
    }

    static class RaftsMonitoringOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPath() {
            return "CCS Subsystems/Rafts/NewMonitoring";
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY) ) {
                return agent.getName();
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TabbedView view = new TabbedView();
            RaftsMonitorFilter filter = new RaftsMonitorFilter(agent.getName());
            view.setFilter(filter);
            view.install();
            return view.getPanel();
        }

    }
}
