package org.lsst.ccs.subsystem.rafts.ui.jas;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.filter.GenericFilter;

/**
 * Rafts monitoring filter.
 *
 * @author The LSST CCS Team
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Rafts monitor filter",
               path="Subsystems/Rafts/Monitor",
               description="Rafts subsystem monitor filter.")
public class RaftsMonitorFilter extends GenericFilter {


// -- Life cycle : -------------------------------------------------------------
    
    public RaftsMonitorFilter(String agents) {
        super("Rafts",agents,"/main/", "", true, "");
    }

    
    @Override
    public List<String> getDisplayPath(String originPath) {
        int i1 = originPath.indexOf(".");
        int i2 = originPath.indexOf(".", i1+1);
        if (i1 == -1 || i2 == -1) return Collections.emptyList();
        String displayPath = originPath.substring(i1 + 1, i2) +"//"+ originPath.substring(i2 + 1);
        return Collections.singletonList(displayPath);
    }
           
}
