package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.util.ArrayList;
import java.util.List;

import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Callable;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;


/**
 * An EmbeddedSubroutine is created on the fly to implement anonymous &lt;call&gt; blocks
 * 
 * @author aubourg
 *
 */
class EmbeddedSubroutine extends Callable {

    private static int sergen = 0; // to get a unique id, could be useful

    public EmbeddedSubroutine(Subroutine parent) {
        this.parent = parent;
        index = ++sergen;
        setId(parent.getId() + "_" + index);
    }

    public List<Call> getCalls() {
        return calls;
    }

    public void setCalls(List<Call> calls) {
        this.calls = calls;
    }
    
    public void setParent(Subroutine parent) {
        this.parent = parent;
    }
    
    public Subroutine getParent() {
        return parent;
    }
    
    public void setIndex(int index) {
        this.index = index;
    }
    
    public int getIndex() {
        return index;
    }

    private List<Call> calls = new ArrayList<>();
    private Subroutine parent;
    private int index;

}
