package org.lsst.ccs.subsystem.rafts.data;

import java.io.Serializable;

/**
 *************************************
 *
 *  Contains a subset of image data
 *
 *  @author Owen Saxton
 *
 *************************************
 */
public class ImageData implements Serializable 
{
    private final long timestamp;  // The image timestamp
    private final int offset;      // The pixel offset of the data within the image
    private final int[] data;      // Array of image pixel data

    public ImageData(long timestamp, int offset, int[] data) {
        this.timestamp = timestamp;
        this.offset = offset;
        this.data = data;
    }
    
    public long getTimestamp() {
        return timestamp;
    }

    public int getOffset() {
        return offset;
    }

    public int[] getData() {
        return data;
    }

    @Deprecated
    public long getTag() {
        return timestamp;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < data.length; j++) {
            if ((j & 0x03) == 0) {
                if (j != 0) str.append("\n");
                str.append(String.format("%08x:", offset + j));
            }
            str.append(String.format(" %08x", data[j]));
        }
        return str.toString();
    }

    private static final long serialVersionUID = 8960836614027519469L;
}
