package org.lsst.ccs.subsystem.rafts.data;

import java.io.Serializable;

/**
 *******************************************
 *
 *  Contains the state of a rafts subsystem
 *
 *  @author Owen Saxton
 *
 *******************************************
 */
public class RaftState implements Serializable 
{
    
    public static final String KEY = "RaftState";
    private final int tickMillis;         // Data status update period (ms)
 
    public RaftState(int tickMillis) {
        this.tickMillis = tickMillis;
    }
    
    public int getTickMillis() {
        return tickMillis;
    }

    @Override
    public String toString() {
        return "tickMillis=" + tickMillis;
    }

    private static final long serialVersionUID = 3660519749859513509L;
}
