/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilderTest;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelUtils;

public class FPGA2ModelUtilsTest {
    @Test
    public void testUtils() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            FPGA2ModelUtils utils = new FPGA2ModelUtils(compiled, Collections.EMPTY_MAP);
            Assert.assertEquals((long)25000000L, (long)utils.getNanosForRoutine("Exposure25ms").getValue());
            Assert.assertEquals((long)6433492320L, (long)utils.getNanosForRoutine("Acquisition").getValue());
            Assert.assertEquals((long)256000L, (long)utils.getPixelsForRoutine("Acquisition").getValue());
        }
    }

    @Test
    public void testUtilsWithParameters() throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ReadCols", 64);
        parameters.put("Exposure", "SlowFlush");
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            FPGA2ModelUtils utils = new FPGA2ModelUtils(compiled, parameters);
            Assert.assertEquals((long)2000000000L, (long)utils.getNanosForRoutine("Exposure25ms").getValue());
            Assert.assertEquals((long)164074452320L, (long)utils.getNanosForRoutine("Acquisition").getValue());
            Assert.assertEquals((long)64000L, (long)utils.getPixelsForRoutine("Acquisition").getValue());
        }
    }
}

