package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType
public class SubroutinePointer implements Visitable, Serializable {

    private static final long serialVersionUID = -7042097614325113912L;

    public SubroutinePointer() {

    }

    public SubroutinePointer(String id, String fullname, Subroutine sub) {
        super();
        this.id = id;
        this.fullname = fullname;
        this.sub = sub;
    }
    
    public SubroutinePointer(String id, String fullname, String subName) {
        super();
        this.id = id;
        this.fullname = fullname;
        this.subName = subName;
    }


    @XmlAttribute(name = "id")
    @XmlID
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name = "fullname")
    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    // initial value
    @XmlIDREF
    @XmlAttribute(name = "sub")
    public Subroutine getSubroutine() {
        return sub;
    }

    public void setSubroutine(Subroutine sub) {
        this.sub = sub;
    }
    
    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @XmlTransient
    public String getSubName() {
        return subName;
    }
    
    public void setSubName(String subName) {
        this.subName = subName;
    }

    private String id;
    private Subroutine sub;
    private String subName;
    String fullname;
}
