package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Clock;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Constant;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Parameter;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerConfig;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerRoutines;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

public interface Visitor {
    public void visit(Sequencer s);
    public void visit(SequencerConfig s);
    public void visit(SequencerRoutines s);
    public void visit(Function f);
    public void visit(FunctionPointer fp);
    public void visit(RepeatFunctionPointer rfp);
    public void visit(SubroutinePointer sp);
    public void visit(RepeatSubroutinePointer rsp);
    public void visit(Parameter p);
    public void visit(Channel c);
    public void visit(Clock c);
    public void visit(Constant c);
    public void visit(Timeslice s);
    public void visit(Subroutine s);
    public void visit(Main s);
    public void visit(Call c);
}
