package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Clock;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Constant;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Parameter;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerConfig;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerRoutines;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

/**
 * This debugging visitor dumps the parsed structure.
 * 
 * @author aubourg
 *
 */
class DumpVisitor extends AbstractVisitor {

    @Override
    public void visit(Sequencer s) {
        System.out.printf("Sequencer\n");
        super.visit(s);
    }

    @Override
    public void visit(SequencerConfig s) {
        System.out.printf("  SequencerConfig\n");
        super.visit(s);
    }

    @Override
    public void visit(SequencerRoutines s) {
        System.out.printf("  SequencerRoutines\n");
        super.visit(s);
    }

    @Override
    public void visit(Function f) {
        System.out.printf("    Function %s [%s]\n", f.getId(), f.getFullname());
        super.visit(f);
    }

    @Override
    public void visit(Subroutine s) {
        System.out.printf("    Subroutine %s [%s]\n", s.getId(),
                s.getFullname());
        super.visit(s);
    }

    @Override
    public void visit(Main s) {
        System.out.printf("    Main %s [%s]\n", s.getId(), s.getFullname());
        super.visit(s);
    }

    @Override
    public void visit(Parameter p) {
        System.out.printf("    Parameter %s [%s] = %s \n", p.getId(),
                p.getFullname(), p.getValue());
    }

    @Override
    public void visit(Channel c) {
        System.out.printf("    Channel %s [%s] @ %d \n", c.getId(),
                c.getFullname(), c.getValue());
    }

    @Override
    public void visit(Constant c) {
        System.out.printf("      Constant %s \n", c.getChannel().getId());
    }

    @Override
    public void visit(Clock c) {
        System.out.printf("      Clock %s \n", c.getChannel().getId());
    }

    @Override
    public void visit(Timeslice s) {
        System.out.printf("      Timeslice  %s %s \n", s.getDuration(),
                s.getValue());
    }

    int calllevel = 0;

    @Override
    public void visit(Call c) {
        String repeat = c.getRepeat();
        if (repeat == null)
            repeat = "1";
        if (c.getRepeatFcnPtr() != null) {
            repeat = "@" + c.getRepeatFcnPtr().getId();
        }
        if (c.getRepeatSubPtr() != null) {
            repeat = "@" + c.getRepeatSubPtr().getId();
        }

        if (c.getFunction() != null) {
            for (int i = 0; i < calllevel; i++)
                System.out.printf("  ");
            System.out.printf("      Call function %s [%s]\n", c.getFunction()
                    .getId(), repeat);
        } else if (c.getFunctionPointer() != null) {
            for (int i = 0; i < calllevel; i++)
                System.out.printf("  ");
            System.out.printf("      Call function @%s [%s]\n", c
                    .getFunctionPointer().getId(), repeat);
        } else if (c.getSubroutine() != null) {
            for (int i = 0; i < calllevel; i++)
                System.out.printf("  ");
            System.out.printf("      Call sub %s [%s]\n", c.getSubroutine()
                    .getId(), repeat);
        } else if (c.getSubroutinePointer() != null) {
            for (int i = 0; i < calllevel; i++)
                System.out.printf("  ");
            System.out.printf("      Call sub @%s [%s]\n", c
                    .getSubroutinePointer().getId(), repeat);
        } else if (c.getCalls() != null) {
            for (int i = 0; i < calllevel; i++)
                System.out.printf("  ");
            System.out.printf("      Call > [%s]\n", repeat);
            calllevel++;
            for (Call cc : c.getCalls()) {
                cc.accept(this);
            }
            calllevel--;
        } else {
            System.out.printf("         NO CALLS ••••• ERROR\n");
        }

    }

    @Override
    public void visit(FunctionPointer fp) {
        System.out.printf("    FunctionPointer %s [%s] -> %s\n", fp.getId(), fp
                .getFullname(), fp.getFunction() == null ? fp.getFcnName() : fp
                .getFunction().getId());
    }

    @Override
    public void visit(RepeatFunctionPointer rfp) {
        System.out.printf("    RepeatFunctionPointer %s [%s] -> %s\n",
                rfp.getId(), rfp.getFullname(), rfp.getN());
    }

    @Override
    public void visit(SubroutinePointer sp) {
        System.out.printf("    SubroutinePointer %s [%s] -> %s\n", sp.getId(),
                sp.getFullname(), sp.getSubroutine() == null ? sp.getSubName()
                        : sp.getSubroutine().getId());

    }

    @Override
    public void visit(RepeatSubroutinePointer rsp) {
        System.out.printf("    RepeatSubroutinePointer %s [%s] -> %s\n",
                rsp.getId(), rsp.getFullname(), rsp.getN());

    }

}
