package org.lsst.ccs.subsystem.rafts.data;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 ********************************************
 *
 * Constants associated with the sequencer
 *
 * @author Owen Saxton
 *
 ********************************************
 */
public class SequencerData {

    public static final int 
            PTR_TYPE_FUNC = 0,
            PTR_TYPE_SUBR = 1,
            PTR_TYPE_FUNC_REP = 2,
            PTR_TYPE_SUBR_REP = 3;

    public static final int REG_READ_ROWS = 0,
            REG_READ_COLS = 1,
            REG_PRE_ROWS = 2,
            REG_PRE_COLS = 3,
            REG_POST_ROWS = 4,
            REG_POST_COLS = 5,
            REG_READ_COLS2 = 6,
            REG_OVER_ROWS = 7,
            REG_OVER_COLS = 8,
            NUM_REGISTERS = 9;

    public static final String PARM_READ_ROWS = "ReadRows",
            PARM_READ_COLS = "ReadCols",
            PARM_PRE_ROWS = "PreRows",
            PARM_PRE_COLS = "PreCols",
            PARM_POST_ROWS = "PostRows",
            PARM_POST_COLS = "PostCols",
            PARM_READ_COLS2 = "ReadCols2",
            PARM_OVER_ROWS = "OverRows",
            PARM_OVER_COLS = "OverCols";

    public static final String[] imageRegNames = {
        PARM_READ_ROWS, PARM_READ_COLS, PARM_PRE_ROWS, PARM_PRE_COLS,
        PARM_POST_ROWS, PARM_POST_COLS, PARM_READ_COLS2, PARM_OVER_ROWS, 
        PARM_OVER_COLS};

    public static final Map<Integer, String> imageRegs = new LinkedHashMap<>();
    static {
        imageRegs.put(REG_PRE_ROWS, PARM_PRE_ROWS);
        imageRegs.put(REG_PRE_COLS, PARM_PRE_COLS);
        imageRegs.put(REG_READ_ROWS, PARM_READ_ROWS);
        imageRegs.put(REG_READ_COLS, PARM_READ_COLS);
        imageRegs.put(REG_POST_ROWS, PARM_POST_ROWS);
        imageRegs.put(REG_POST_COLS, PARM_POST_COLS);
        imageRegs.put(REG_READ_COLS2, PARM_READ_COLS2);
        imageRegs.put(REG_OVER_ROWS, PARM_OVER_ROWS);
        imageRegs.put(REG_OVER_COLS, PARM_OVER_COLS);
    }

}
