package org.lsst.ccs.subsystem.rafts.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 * Raft level Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum RaftAlert {

    /**
     * Alert raised when the ASPICs temperature is too hot.
     */
    ASPICS_TEMPERATURE_TOO_HIGH("AspicsHighTemp","Alert for Aspics temperture too high"),
    /**
     * Alert raised when the ASPICs temperature is too hot.
     */
    ASPICS_TEMPERATURE_TOO_LOW("AspicsLowTemp","Alert for Aspics temperture too low"),
    /**
     * Alert raised when the Reb Board temperature is too hot.
     */
    REB_BOARD_TEMPERATURE_TOO_HIGH("RebBoardHighTemp","Alert for Reb Board temperture too high"),
    /**
     * Alert raised when the Reb Board temperature is too low.
     */
    REB_BOARD_TEMPERATURE_TOO_LOW("RebBoardLowTemp","Alert for Reb Board temperture too low"),
    /** 
     * Alert raised when a REB is not connected.
     */
    REB_NOT_CONNECTED("RebNotConnected","Alert raised when a REB is not connected");
    
    
    private final String id, description;
    
    RaftAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return getAlert(null);
    }
    
    public Alert getAlert(String path) {
        String aId = null;
        if ( path != null && ! path.isEmpty() ) {
            aId = id+"/"+path;
        } else {
            aId = id;
        }
        return new Alert(aId,description);
    }
    
}
