package org.lsst.ccs.subsystem.rafts.fpga.xml;

//TODO XmlSchema...

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

//@XmlRootElement(name = "sequencer-config")
@XmlType(propOrder = { "parameters", "channels", "funcPtrs", "funcRepPtrs",
        "subPtrs", "subRepPtrs", "functions" })
public class SequencerConfig implements Visitable {

    // TODO for new version of FPGA, add registers section
    // each register has a symbolic name, an address in the four blocs of 16
    // registers,
    // and an initial value
    // when a repeat count references a register and not a parameter or
    // constant,
    // the new indirect opcode is used

    // similar mechanism for indirect functions

    public SequencerConfig() {
    }

    // a hashmap would be smarter than a list for future use.
    // see how to map a map, or convert after?

    @XmlElement(name = "parameter")
    @XmlElementWrapper(name = "parameters")
    public List<Parameter> getParameters() {
        return parms;
    }

    public void setParmameters(List<Parameter> parms) {
        this.parms = parms;
    }

    @XmlElement(name = "channel")
    @XmlElementWrapper(name = "channels")
    public List<Channel> getChannels() {
        return channels;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    @XmlElement(name = "funcptr")
    @XmlElementWrapper(name = "funcptrs")
    public List<FunctionPointer> getFuncPtrs() {
        return funcPtrs;
    }

    public void setFuncPtrs(List<FunctionPointer> funcPtrs) {
        this.funcPtrs = funcPtrs;
    }

    @XmlElement(name = "funcrepptr")
    @XmlElementWrapper(name = "funcrepptrs")
    public List<RepeatFunctionPointer> getFuncRepPtrs() {
        return funcRepeatPtrs;
    }

    public void setFuncRepPtrs(List<RepeatFunctionPointer> funcRepeatPtrs) {
        this.funcRepeatPtrs = funcRepeatPtrs;
    }

    @XmlElement(name = "subptr")
    @XmlElementWrapper(name = "subptrs")
    public List<SubroutinePointer> getSubPtrs() {
        return subPtrs;
    }

    public void setSubPtrs(List<SubroutinePointer> subPtrs) {
        this.subPtrs = subPtrs;
    }

    @XmlElement(name = "subrepptr")
    @XmlElementWrapper(name = "subrepptrs")
    public List<RepeatSubroutinePointer> getSubRepPtrs() {
        return subRepeatPtrs;
    }

    public void setSubRepPtrs(List<RepeatSubroutinePointer> subRepeatPtrs) {
        this.subRepeatPtrs = subRepeatPtrs;
    }

    @XmlElement(name = "function")
    @XmlElementWrapper(name = "functions")
    public List<Function> getFunctions() {
        return functions;
    }

    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    private List<Parameter> parms = new ArrayList<>();
    private List<Channel> channels = new ArrayList<>();
    private List<FunctionPointer> funcPtrs = new ArrayList<>();
    private List<RepeatFunctionPointer> funcRepeatPtrs = new ArrayList<>();
    private List<SubroutinePointer> subPtrs = new ArrayList<>();
    private List<RepeatSubroutinePointer> subRepeatPtrs = new ArrayList<>();
    private List<Function> functions = new ArrayList<>();

    public void validate() {

    	
    	
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

}
