package org.lsst.ccs.subsystem.rafts.config;

import java.io.Serializable;

public class BiasDACS implements Serializable {

    public static final int
        GD         = 0,
        OD         = 1,
        OG         = 2,
        OG_SH      = 3,
        CS_GATE    = 4,
        RD         = 5,
        NUM_VALUES = 6;

    private final double[] pValues = new double[NUM_VALUES];
    private final int[]    values = new int[NUM_VALUES];

    public int[] getValues() {
        return values;
    }

    public double[] getPValues() {
        return pValues;
    }

    public void copyFrom(BiasDACS bias) {
        System.arraycopy(bias.pValues, 0, pValues, 0, pValues.length);
        System.arraycopy(bias.values, 0, values, 0, values.length);
    }

    private static final long serialVersionUID = -8697350564910725531L;
}
