package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType(propOrder = { "fullname", "clocks", "timeslices", "constants" })
public class Function extends Callable implements Visitable, Serializable {

    private static final long serialVersionUID = -8043260878259850203L;

    public Function() {
    }
    
    public Function(String id, String fullname) {
        super();
        setId(id);
        this.fullname = fullname;
    }

    @XmlElement(name = "fullname")
    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }
    
    @XmlElement(name = "clock")
    @XmlElementWrapper(name = "clocklist")
    public List<Clock> getClocks() {
        return clocks;
    }
    
    public void setClocks(List<Clock> clocks) {
        this.clocks = clocks;
    }
    
    @XmlElement(name = "timeslice")
    @XmlElementWrapper(name = "slicelist")
    public LinkedList<Timeslice> getTimeslices() {
        return timeslices;
    }
    
    public void setTimeslices(List<Timeslice> timeslices) {
        this.timeslices = timeslices instanceof LinkedList ? (LinkedList) timeslices : new LinkedList(timeslices);
    }
    
    @XmlElement(name = "constant")
    @XmlElementWrapper(name = "constants")
    public List<Constant> getConstants() {
        return constants;
    }
    
    public void setConstants(List<Constant> constants) {
        this.constants = constants;
    }
    
    private String fullname;
    private List<Clock> clocks = new ArrayList<>();
    private LinkedList<Timeslice> timeslices = new LinkedList<>();
    private List<Constant> constants = new ArrayList<>();
    
    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

}

