package org.lsst.ccs.subsystem.rafts.config;

import java.io.Serializable;

public class DACS implements Serializable {

    public static final int
        SCLK_LOW       = 0,
        SCLK_HIGH      = 1,
        PCLK_LOW       = 2,
        PCLK_HIGH      = 3,
        RG_LOW         = 4,
        RG_HIGH        = 5,
        SCLK_LOW_SH    = 6,
        SCLK_HIGH_SH   = 7,
        PCLK_LOW_SH    = 8,
        PCLK_HIGH_SH   = 9,
        RG_LOW_SH      = 10,
        RG_HIGH_SH     = 11,
        CSGATE_1       = 12,
        CSGATE_2       = 13,
        CSGATE_3       = 14,
        FSB_CTRL       = 15,
        OD_CTRL        = 16,
        GD             = 17,
        RD             = 18,
        OG             = 19,
        OG_SH          = 20,
        NUM_DACS_P     = 6,
        NUM_DACS       = 21;

    private final double[] pValues = new double[NUM_DACS_P];
    private final int[]    values = new int[NUM_DACS];

    public int[] getValues() {
        return values;
    }

    public double[] getPValues() {
        return pValues;
    }

    public void copyFrom(DACS dacs) {
        System.arraycopy(dacs.pValues, 0, pValues, 0, pValues.length);
        System.arraycopy(dacs.values, 0, values, 0, values.length);
    }

    private static final long serialVersionUID = -5489189161132382674L;
}
