package org.lsst.ccs.subsystem.rafts.fpga.xml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType
public class Parameter implements Visitable {
    
    public Parameter() {
    }
    
    public Parameter(String id, String fullname, String value) {
        super();
        this.id = id;
        this.fullname = fullname;
        this.value = value;
    }

    @XmlAttribute(name = "id")
    @XmlID
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name = "fullname")
    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    @XmlElement(name = "value")
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private String id;
    private String fullname;
    private String value;
    
    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }


 }
