package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType
public class Constant implements Visitable, Serializable {

    private static final long serialVersionUID = 570892309733223704L;
    
    public Constant() {
    }

    public Constant(Channel channel, String value) {
        super();
        this.channel = channel;
        this.value = value;
    }

    @XmlAttribute(name = "ref", required = true)
    @XmlIDREF
    public Channel getChannel() {
        return channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @XmlValue
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value.trim();
    }

    private Channel channel;
    private String value;

    @Override
    public void accept(Visitor v) {
        if (channel == null)
            throw new RuntimeException("no valid channel for constant");
        v.visit(this);
    }

}
