package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType
public class Clock implements Visitable, Serializable  {

    private static final long serialVersionUID = -4084414729583260712L;
    
    public Clock() {
    }

    public Clock(Channel channel) {
        super();
        this.channel = channel;
    }

    @XmlAttribute(name = "ref")
    @XmlIDREF
    public Channel getChannel() {
        return channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    private Channel channel;
    
    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

}