package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType(propOrder = { "fullname", "calls" })
public class Subroutine extends Callable implements Visitable, Serializable {

    private static final long serialVersionUID = 430725144253153130L;
    
    public Subroutine() {
    }

    public Subroutine(String id, String fullname) {
        super();
        setId(id);
        setFullname(fullname);
    }

    @XmlElement(name = "fullname")
    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    @XmlElement(name = "call")
    public List<Call> getCalls() {
        return calls;
    }

    public void setCalls(List<Call> calls) {
        this.calls = calls;
    }

    private String fullname;
    private List<Call> calls = new ArrayList<Call>();

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public void complete(Sequencer s) {
        for (Call c : calls) {
            if (c.getFunction() == null && c.getSubroutine() == null
                    && c.getFunctionPointer() == null
                    && c.getSubroutinePointer() == null) {
                if (c.getFcnName() != null) {
                    String name = c.getFcnName();
                    if (name.startsWith("@")) {
                        String fname = name.substring(1);
                        FunctionPointer fp = s
                                .getSequencerConfig()
                                .getFuncPtrs()
                                .stream()
                                .filter(m -> m.getId().equals(fname))
                                .findFirst()
                                .orElseThrow(
                                        () -> new RuntimeException(
                                                "cannot find function pointer "
                                                        + fname));
                        c.setFunctionPointer(fp);
                    } else {
                        Function f = s
                                .getSequencerConfig()
                                .getFunctions()
                                .stream()
                                .filter(m -> m.getId().equals(name))
                                .findFirst()
                                .orElseThrow(
                                        () -> new RuntimeException(
                                                "cannot find function  " + name));
                        c.setFunction(f);
                    }
                } else if (c.getSubName() != null) {
                    String name = c.getSubName();
                    if (name.startsWith("@")) {
                        String fname = name.substring(1);
                        SubroutinePointer sp = s
                                .getSequencerConfig()
                                .getSubPtrs()
                                .stream()
                                .filter(m -> m.getId().equals(fname))
                                .findFirst()
                                .orElseThrow(
                                        () -> new RuntimeException(
                                                "cannot find subroutine pointer "
                                                        + fname));
                        c.setSubroutinePointer(sp);
                    } else {
                        Subroutine sub = s
                                .getSequencerRoutines()
                                .getSubroutines()
                                .stream()
                                .filter(m -> m.getId().equals(name))
                                .findFirst()
                                .orElseThrow(
                                        () -> new RuntimeException(
                                                "cannot find subroutine  "
                                                        + name));
                        c.setSubroutine(sub);
                    }
                } else {
                    throw new RuntimeException(
                            " nothing defined for call in subroutine "
                                    + getId() + " " + getFullname());
                }
            }
            if (c.getRepeatFcnPtr() == null && c.getRepeatSubPtr() == null
                    && c.getRepeatValue() <= 1 && c.getRepeat() != null) {
                String n = c.getRepeat();
                // @string, string, number
                if (n.startsWith("@")) {
                    String fname = n.substring(1);
                    if (c.getFunction() != null
                            || c.getFunctionPointer() != null) {
                        RepeatFunctionPointer rfp = s
                                .getSequencerConfig()
                                .getFuncRepPtrs()
                                .stream()
                                .filter(m -> m.getId().equals(fname))
                                .findFirst()
                                .orElseThrow(
                                        () -> new RuntimeException(
                                                "cannot find repeat function pointer  "
                                                        + fname));
                        c.setRepeat(null);
                        c.setRepeatFcnPtr(rfp);
                    } else {
                        RepeatSubroutinePointer rsp = s
                                .getSequencerConfig()
                                .getSubRepPtrs()
                                .stream()
                                .filter(m -> m.getId().equals(fname))
                                .findFirst()
                                .orElseThrow(
                                        () -> new RuntimeException(
                                                "cannot find repeat subroutine pointer "
                                                        + fname));
                        c.setRepeat(null);
                        c.setRepeatSubPtr(rsp);
                    }
                } else if (n.matches("\\d+")) {
                    c.setRepeatValue(Integer.parseInt(n));
                }
            }
        }

    }
}
