package org.lsst.ccs.subsystem.rafts.config;

import java.io.Serializable;

public class CABAC implements Serializable {

    public static final int
        RD         = 0,
        OG         = 1,
        GD         = 2,
        OD0_RDO    = 3,
        OD1_RDO    = 4,
        OD0_EXP    = 5,
        OD1_EXP    = 6,
        RG_RISE    = 7,
        RG_FALL    = 8,
        SCLK0_RISE = 9,
        SCLK0_FALL = 10,
        SCLK1_RISE = 11,
        SCLK1_FALL = 12,
        SCLK2_RISE = 13,
        SCLK2_FALL = 14,
        PCLK0_RISE = 15,
        PCLK0_FALL = 16,
        PCLK1_RISE = 17,
        PCLK1_FALL = 18,
        PCLK2_RISE = 19,
        PCLK2_FALL = 20,
        PCLK3_RISE = 21,
        PCLK3_FALL = 22,
        NUM_VALUES = 23;

    private final int[]    values = new int[NUM_VALUES];
    private final double[] scales = new double[NUM_VALUES];

    public int[] getValues() {
        return values;
    }

    public double[] getScales() {
        return scales;
    }

    public void copyFrom(CABAC cbc) {
        System.arraycopy(cbc.values, 0, values, 0, values.length);
    }

    private static final long serialVersionUID = -2291973015292258025L;
}
