/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.junit.Test;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.DumpVisitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Clock;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Constant;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Parameter;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerConfig;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerRoutines;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

public class SequencerTest {
    @Test
    public void testSequencer() throws Exception {
        Sequencer s = new Sequencer();
        SequencerConfig sc = s.getSequencerConfig();
        sc.getParameters().add(new Parameter("ReadLines", "Number of rows of the sensor", "2020"));
        sc.getParameters().add(new Parameter("ReadColumns", "Number of columns of the sensor", "540"));
        Channel p1 = new Channel("P1", "Parallel clock 1", 1);
        sc.getChannels().add(p1);
        Channel p2 = new Channel("P2", "Parallel clock 2", 2);
        sc.getChannels().add(p2);
        Channel p3 = new Channel("P3", "Parallel clock 3", 3);
        sc.getChannels().add(p3);
        Channel p4 = new Channel("P4", "Parallel clock 4", 4);
        sc.getChannels().add(p4);
        Function transferLine = new Function("TransferLine", "Single line transfer");
        transferLine.getClocks().add(new Clock(p1));
        transferLine.getClocks().add(new Clock(p2));
        transferLine.getTimeslices().add(new Timeslice("10 ns", "11"));
        transferLine.getTimeslices().add(new Timeslice("20 ns", "10"));
        transferLine.getTimeslices().add(new Timeslice("10 ns", "01"));
        transferLine.getConstants().add(new Constant(p3, "1"));
        transferLine.getConstants().add(new Constant(p4, "1"));
        sc.getFunctions().add(transferLine);
        Function readPixel = new Function("ReadPixel", "Single pixel read");
        readPixel.getTimeslices().add(new Timeslice("10 ns", "11"));
        readPixel.getTimeslices().add(new Timeslice("20 ns", "10"));
        sc.getFunctions().add(readPixel);
        Function serialIdle = new Function("SerialIdle", "Single pixel read-like sequence");
        serialIdle.getTimeslices().add(new Timeslice("10 ns", "11"));
        serialIdle.getTimeslices().add(new Timeslice("20 ns", "10"));
        sc.getFunctions().add(serialIdle);
        Function defaultFunction = new Function("Default", "Default state when not operating");
        defaultFunction.getTimeslices().add(new Timeslice("10 ns", "11"));
        defaultFunction.getTimeslices().add(new Timeslice("20 ns", "10"));
        sc.getFunctions().add(defaultFunction);
        Function flushRegister = new Function("FlushRegister", "");
        flushRegister.getTimeslices().add(new Timeslice("10 ns", "11"));
        flushRegister.getTimeslices().add(new Timeslice("20 ns", "10"));
        sc.getFunctions().add(flushRegister);
        Function clearCCD = new Function("ClearCCD", "");
        clearCCD.getTimeslices().add(new Timeslice("10 ns", "11"));
        clearCCD.getTimeslices().add(new Timeslice("20 ns", "10"));
        sc.getFunctions().add(clearCCD);
        Function idleLine = new Function("IdleLine", "");
        idleLine.getTimeslices().add(new Timeslice("10 ns", "11"));
        idleLine.getTimeslices().add(new Timeslice("20 ns", "10"));
        sc.getFunctions().add(idleLine);
        SequencerRoutines sr = s.getSequencerRoutines();
        Subroutine readFrame = new Subroutine("ReadFrame", "Full readout of a CCD frame");
        Call c = new Call(flushRegister, "NumReadColumns");
        readFrame.getCalls().add(c);
        c = new Call();
        c.setRepeat("NumReadLines");
        c.setCalls(new ArrayList());
        c.getCalls().add(new Call(transferLine));
        c.getCalls().add(new Call(readPixel, "NumReadColumns"));
        readFrame.getCalls().add(c);
        sr.getSubroutines().add(readFrame);
        Main testOperation = new Main("TestOperation", "Normal operation during tests");
        c = new Call(clearCCD);
        testOperation.getCalls().add(c);
        c = new Call(flushRegister, "infinity");
        testOperation.getCalls().add(c);
        c = new Call(readFrame);
        testOperation.getCalls().add(c);
        c = new Call(idleLine, "infinity");
        testOperation.getCalls().add(c);
        sr.getMains().add(testOperation);
        File tmp = File.createTempFile("sequencer", ".xml");
        tmp.deleteOnExit();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sequencer.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        try (FileOutputStream out = new FileOutputStream(tmp);){
            m.marshal((Object)s, (OutputStream)out);
        }
        Unmarshaller u = context.createUnmarshaller();
        try (InputStream si = Sequencer.class.getResourceAsStream("schema.xsd");){
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(new StreamSource(si));
            u.setSchema(schema);
        }
        Sequencer s2 = (Sequencer)u.unmarshal((InputStream)new FileInputStream(tmp));
        new DumpVisitor().visit(s2);
    }
}

