package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.util.LinkedHashSet;
import java.util.Set;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

// TODO is the id useful ?
@XmlType
public class Timeslice implements Visitable {

    private String duration;
    private String value;

    private int index;
    private int startNanos;
    private int durationNanos;
    private final Set<Channel> upChannels = new LinkedHashSet<>();

    public Timeslice() {
    }

    public Timeslice(String duration, String value) {
        super();
        this.duration = duration;
        this.value = value;
    }

    @XmlElement(name = "duration")
    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    @XmlElement(name = "value")
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /* used during processing */
    @XmlTransient
    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @XmlTransient
    public int getStartNanos() {
        return startNanos;
    }

    public void setStartNanos(int startNanos) {
        this.startNanos = startNanos;
    }

    @XmlTransient
    public int getDurationNanos() {
        return durationNanos;
    }

    public void setDurationNanos(int durationNanos) {
        this.durationNanos = durationNanos;
    }

    public Set<Channel> getUpChannels() {
        return upChannels;
    }

    public void addUpChannel(Channel c) {
        upChannels.add(c);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

}
