package org.lsst.ccs.subsystem.rafts.fpga.xml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType
public class Channel implements Visitable {
    
    // what does the "value" mean?
    
    public Channel() {
    }
    
    public Channel(String id, String fullname, int value) {
        super();
        this.id = id;
        this.fullname = fullname;
        this.value = value;
    }


    @XmlAttribute(name = "id")
    @XmlID
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name = "fullname")
    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    @XmlElement(name = "value")
    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    private String id;
    private String fullname;
    private int value;
    
    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }


 }
