package org.lsst.ccs.subsystem.rafts.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 *****************************************************************
 *
 *  Contains information describing the full raft system state.
 *
 *  Sent on the status bus upon request.
 *
 *  @author Owen Saxton
 *
 *****************************************************************
 */
public class RaftFullState implements Serializable {

    private final RaftState raftState;
    private final MonitorFullState monitorState;

    public RaftFullState(RaftState rState, MonitorFullState mState) {
        raftState = rState;
        monitorState = mState;
    }

    public RaftState getRaftState() {
        return raftState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

    private static final long serialVersionUID = 225336324191073878L;
}
