package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType(propOrder = { "repeat", "repeatFcnPtr", "repeatSubPtr", "calls" })
public class Call implements Visitable {

    public Call() {
    }

    public Call(Function c) {
        setFunction(c);
    }

    public Call(Function c, String repeat) {
        setFunction(c);
        this.repeat = repeat;
    }

    public Call(Subroutine c) {
        setSubroutine(c);
    }

    public Call(Subroutine c, String repeat) {
        setSubroutine(c);
        this.repeat = repeat;
    }

    public Call(String repeat, List<Call> subroutine) {
        this.repeat = repeat;
        setCalls(subroutine);
    }

    private void checkConstraints() {
        // only one out of fcn, sub, fcnptr, subptr, calls
        int i = 0;
        StringBuilder b = new StringBuilder();
        if (fcn != null) {
            i++;
            b.append("fcn ");
        }
        if (sub != null) {
            i++;
            b.append("sub ");
        }
        if (fcnPtr != null) {
            i++;
            b.append("fcnPtr ");
        }
        if (subPtr != null) {
            i++;
            b.append("subPtr ");
        }
        if (calls != null) {
            i++;
            b.append("calls ");
        }

        if (i > 1)
            throw new RuntimeException("cannot specify simultaneously "
                    + b.toString());

        // repeat ptr must be consistent with the nature of the call

        if (repeatFcnPtr != null) {
            if (sub != null || subPtr != null) {
                throw new RuntimeException("cannot specify repeatfcnptr with sub/subptr");
            }
        }
        if (repeatSubPtr != null) {
            if (fcn != null || fcnPtr != null) {
                throw new RuntimeException("cannot specify repeatsubptr with fcn/fcnptr");
            }
        }

        if (repeat != null && (repeatSubPtr != null || repeatFcnPtr != null)) {
            throw new RuntimeException("cannot specify repeat and a repeat pointer");
        }

       if (repeat != null && repeat.equals("infinity")) {
           if (sub != null || subPtr != null) {
               throw new RuntimeException("cannot specify infinity for a subroutine");
           }
           if (repeatSubPtr != null || repeatFcnPtr != null) {
               throw new RuntimeException("cannot specify infinity and a repeat attribute");
           }
        }
    }

    // could use only string in XML and smartly convert to ptr if prefixed by
    // "@"
    // this is a stricter schema
    // we could have both?

    @XmlIDREF
    @XmlAttribute(name = "fcn")
    public Function getFunction() {
        return fcn;
    }

    public void setFunction(Function fcn) {
        this.fcn = fcn;
        checkConstraints();
    }

    @XmlIDREF
    @XmlAttribute(name = "sub")
    public Subroutine getSubroutine() {
        return sub;
    }

    public void setSubroutine(Subroutine sub) {
        this.sub = sub;
        checkConstraints();
    }

    @XmlIDREF
    @XmlAttribute(name = "fcnptr")
    public FunctionPointer getFunctionPointer() {
        return fcnPtr;
    }

    public void setFunctionPointer(FunctionPointer fcnPtr) {
        this.fcnPtr = fcnPtr;
        checkConstraints();
    }

    @XmlIDREF
    @XmlAttribute(name = "subptr")
    public SubroutinePointer getSubroutinePointer() {
        return subPtr;
    }

    public void setSubroutinePointer(SubroutinePointer subPtr) {
        this.subPtr = subPtr;
        checkConstraints();
    }

    @XmlIDREF
    @XmlElement(name = "repeatfcnptr")
    public RepeatFunctionPointer getRepeatFcnPtr() {
        return repeatFcnPtr;
    }

    public void setRepeatFcnPtr(RepeatFunctionPointer repeatFcnPtr) {
        this.repeatFcnPtr = repeatFcnPtr;
        checkConstraints();
    }

    @XmlIDREF
    @XmlElement(name = "repeatsubptr")
    public RepeatSubroutinePointer getRepeatSubPtr() {
        return repeatSubPtr;
    }

    public void setRepeatSubPtr(RepeatSubroutinePointer repeatSubPtr) {
        this.repeatSubPtr = repeatSubPtr;
        checkConstraints();
    }

    @XmlElement(name = "repeat", required = false, defaultValue = "1")
    public String getRepeat() {
        return repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
        if (repeat != null && repeat.equals("1"))
            this.repeat = null;
        else
            this.repeat = repeat;
        checkConstraints();
    }

    @XmlElement(name = "call")
    public List<Call> getCalls() {

      //  if (calls == null && fcn == null && sub == null && fcnPtr == null
      //          && subPtr == null)
      //      calls = new ArrayList<Call>();
        return calls;
    }

    public void setCalls(List<Call> calls) {
        this.calls = calls;
        checkConstraints();
    }

    private Function fcn;
    private Subroutine sub;
    private String repeat = null;
    private List<Call> calls;

    private FunctionPointer fcnPtr;
    private SubroutinePointer subPtr;
    private RepeatFunctionPointer repeatFcnPtr;
    private RepeatSubroutinePointer repeatSubPtr;

    private boolean infinity;
    private int repeatValue;
    
    private String fcnName;
    private String subName;

    @XmlTransient
    public boolean isInfinity() {
        return infinity;
    }

    public void setInfinity(boolean infinity) {
        this.infinity = infinity;
        checkConstraints();
    }

    @XmlTransient
    public int getRepeatValue() {
        return repeatValue;
    }

    public void setRepeatValue(int repeatValue) {
        this.repeatValue = repeatValue;
    }
    
    @XmlTransient
    public String getFcnName() {
        return fcnName;
    }
    
    public void setFcnName(String fcnName) {
        this.fcnName = fcnName;
    }
    
    @XmlTransient
    public String getSubName() {
        return subName;
    }
    
    public void setSubName(String subName) {
        this.subName = subName;
    }
    


    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

}
