package org.lsst.ccs.subsystem.rafts.fpga.xml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

@XmlType
public class RepeatFunctionPointer implements Visitable {

    public RepeatFunctionPointer() {

    }

    public RepeatFunctionPointer(String id, String fullname, int n) {
        super();
        this.id = id;
        this.fullname = fullname;
        this.n = n;
    }

    @XmlAttribute(name = "id")
    @XmlID
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name = "fullname")
    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    // initial value
    @XmlAttribute(name = "n")
    public int getN() {
        return n;
    }

    public void setN(int n) {
        this.n = n;
    }
    
    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }


    private String id;
    private int n;
    String fullname;

}
